/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionEvent;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionListener;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.TestingLeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriver;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerExtension;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.shaded.curator5.org.apache.curator.RetryPolicy;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.ACLProvider;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.CreateBuilder;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.flink.shaded.curator5.org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.ACL;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZooKeeperLeaderElectionTest {
    private final ZooKeeperExtension zooKeeperExtension = new ZooKeeperExtension();
    @RegisterExtension
    final EachCallbackWrapper<ZooKeeperExtension> zooKeeperResource = new EachCallbackWrapper((CustomExtension)this.zooKeeperExtension);
    @RegisterExtension
    final TestingFatalErrorHandlerExtension testingFatalErrorHandlerResource = new TestingFatalErrorHandlerExtension();
    private Configuration configuration;
    private static final String COMPONENT_ID = "component-id";
    private static final String LEADER_ADDRESS = "pekko://user/jobmanager";
    private static final long timeout = 200000L;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLeaderElectionTest.class);

    ZooKeeperLeaderElectionTest() {
    }

    @BeforeEach
    void before() {
        this.configuration = new Configuration();
        this.configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)((ZooKeeperExtension)this.zooKeeperResource.getCustomExtension()).getConnectString());
        this.configuration.set(HighAvailabilityOptions.HA_MODE, (Object)"zookeeper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testZooKeeperLeaderElectionRetrieval() throws Exception {
        TestingLeaderElectionListener electionEventHandler = new TestingLeaderElectionListener();
        TestingLeaderRetrievalEventHandler retrievalEventHandler = new TestingLeaderRetrievalEventHandler();
        try (ZooKeeperLeaderElectionDriver leaderElectionDriver = this.createAndInitLeaderElectionDriver(this.createZooKeeperClient(), electionEventHandler);
             ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = ZooKeeperUtils.createLeaderRetrievalDriverFactory((CuratorFramework)this.createZooKeeperClient(), (String)COMPONENT_ID).createLeaderRetrievalDriver((LeaderRetrievalEventHandler)retrievalEventHandler, retrievalEventHandler::handleError);){
            electionEventHandler.await(LeaderElectionEvent.IsLeaderEvent.class);
            UUID leaderSessionID = UUID.randomUUID();
            leaderElectionDriver.publishLeaderInformation(COMPONENT_ID, LeaderInformation.known((UUID)leaderSessionID, (String)LEADER_ADDRESS));
            retrievalEventHandler.waitForNewLeader();
            Assertions.assertThat((Comparable)retrievalEventHandler.getLeaderSessionID()).isEqualTo((Object)leaderSessionID);
            Assertions.assertThat((String)retrievalEventHandler.getAddress()).isEqualTo(LEADER_ADDRESS);
        }
        finally {
            electionEventHandler.failIfErrorEventHappened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testZooKeeperReelection() throws Exception {
        Deadline deadline = Deadline.fromNow((Duration)Duration.ofMinutes(5L));
        int num = 10;
        DefaultLeaderElectionService[] leaderElectionService = new DefaultLeaderElectionService[num];
        LeaderElection[] leaderElections = new LeaderElection[num];
        TestingContender[] contenders = new TestingContender[num];
        DefaultLeaderRetrievalService leaderRetrievalService = null;
        TestingListener listener = new TestingListener();
        try {
            leaderRetrievalService = ZooKeeperUtils.createLeaderRetrievalService((CuratorFramework)this.createZooKeeperClient(), (String)COMPONENT_ID, (Configuration)new Configuration());
            LOG.debug("Start leader retrieval service for the TestingListener.");
            leaderRetrievalService.start((LeaderRetrievalListener)listener);
            for (int i = 0; i < num; ++i) {
                ZooKeeperLeaderElectionDriverFactory driverFactory = new ZooKeeperLeaderElectionDriverFactory(this.createZooKeeperClient());
                leaderElectionService[i] = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory);
                leaderElections[i] = leaderElectionService[i].createLeaderElection(COMPONENT_ID);
                contenders[i] = new TestingContender(this.createAddress(i), leaderElections[i]);
                LOG.debug("Start leader election service for contender #{}.", (Object)i);
                contenders[i].startLeaderElection();
            }
            String pattern = "pekko://user/jobmanager_(\\d+)";
            Pattern regex = Pattern.compile(pattern);
            int numberSeenLeaders = 0;
            while (deadline.hasTimeLeft() && numberSeenLeaders < num) {
                LOG.debug("Wait for new leader #{}.", (Object)numberSeenLeaders);
                String string = listener.waitForNewLeader();
                Matcher m = regex.matcher(string);
                if (m.find()) {
                    int index = Integer.parseInt(m.group(1));
                    TestingContender contender = contenders[index];
                    if (!string.equals(this.createAddress(index)) || !listener.getLeaderSessionID().equals(contender.getLeaderSessionID())) continue;
                    LOG.debug("Stop leader election service of contender #{}.", (Object)numberSeenLeaders);
                    leaderElections[index].close();
                    leaderElections[index] = null;
                    leaderElectionService[index].close();
                    leaderElectionService[index] = null;
                    ++numberSeenLeaders;
                    continue;
                }
                Assertions.fail((String)"Did not find the leader's index.");
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)deadline.isOverdue()).as("Did not complete the leader reelection in time.", new Object[0])).isFalse();
            Assertions.assertThat((int)num).isEqualTo(numberSeenLeaders);
        }
        finally {
            if (leaderRetrievalService != null) {
                leaderRetrievalService.stop();
            }
            for (LeaderElection leaderElection : leaderElections) {
                if (leaderElection == null) continue;
                leaderElection.close();
            }
            for (LeaderElection leaderElection : leaderElectionService) {
                if (leaderElection == null) continue;
                leaderElection.close();
            }
        }
    }

    private String createAddress(int i) {
        return "pekko://user/jobmanager_" + i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testZooKeeperReelectionWithReplacement() throws Exception {
        int num = 3;
        int numTries = 30;
        DefaultLeaderElectionService[] leaderElectionService = new DefaultLeaderElectionService[num];
        LeaderElection[] leaderElections = new LeaderElection[num];
        TestingContender[] contenders = new TestingContender[num];
        DefaultLeaderRetrievalService leaderRetrievalService = null;
        TestingListener listener = new TestingListener();
        try {
            leaderRetrievalService = ZooKeeperUtils.createLeaderRetrievalService((CuratorFramework)this.createZooKeeperClient(), (String)COMPONENT_ID, (Configuration)new Configuration());
            leaderRetrievalService.start((LeaderRetrievalListener)listener);
            for (int i = 0; i < num; ++i) {
                ZooKeeperLeaderElectionDriverFactory driverFactory = new ZooKeeperLeaderElectionDriverFactory(this.createZooKeeperClient());
                leaderElectionService[i] = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory);
                leaderElections[i] = leaderElectionService[i].createLeaderElection(COMPONENT_ID);
                contenders[i] = new TestingContender("pekko://user/jobmanager_" + i + "_0", leaderElections[i]);
                contenders[i].startLeaderElection();
            }
            String pattern = "pekko://user/jobmanager_(\\d+)_(\\d+)";
            Pattern regex = Pattern.compile(pattern);
            for (int i = 0; i < numTries; ++i) {
                listener.waitForNewLeader();
                String string = listener.getAddress();
                Matcher m = regex.matcher(string);
                if (!m.find()) {
                    throw new Exception("Did not find the leader's index.");
                }
                int index = Integer.parseInt(m.group(1));
                int lastTry = Integer.parseInt(m.group(2));
                Assertions.assertThat((Comparable)listener.getLeaderSessionID()).isEqualTo((Object)contenders[index].getLeaderSessionID());
                leaderElections[index].close();
                leaderElections[index] = null;
                leaderElectionService[index].close();
                leaderElections[index] = null;
                ZooKeeperLeaderElectionDriverFactory driverFactory = new ZooKeeperLeaderElectionDriverFactory(this.createZooKeeperClient());
                leaderElectionService[index] = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory);
                leaderElections[index] = leaderElectionService[index].createLeaderElection(COMPONENT_ID);
                contenders[index] = new TestingContender("pekko://user/jobmanager_" + index + "_" + (lastTry + 1), leaderElections[index]);
                contenders[index].startLeaderElection();
            }
        }
        finally {
            if (leaderRetrievalService != null) {
                leaderRetrievalService.stop();
            }
            for (LeaderElection leaderElection : leaderElections) {
                if (leaderElection == null) continue;
                leaderElection.close();
            }
            for (LeaderElection leaderElection : leaderElectionService) {
                if (leaderElection == null) continue;
                leaderElection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLeaderChangeWriteLeaderInformationOnlyOnce() throws Exception {
        TestingLeaderElectionListener electionEventHandler = new TestingLeaderElectionListener();
        try (ZooKeeperLeaderElectionDriver leaderElectionDriver = this.createAndInitLeaderElectionDriver(this.createZooKeeperClient(), electionEventHandler);){
            electionEventHandler.await(LeaderElectionEvent.IsLeaderEvent.class);
            leaderElectionDriver.publishLeaderInformation(COMPONENT_ID, LeaderInformation.known((UUID)UUID.randomUUID(), (String)LEADER_ADDRESS));
            electionEventHandler.await(LeaderElectionEvent.LeaderInformationChangeEvent.class);
            ((OptionalAssert)Assertions.assertThat(electionEventHandler.await(LeaderElectionEvent.LeaderInformationChangeEvent.class, Duration.ofMillis(5L))).as("Another leader information update is not expected.", new Object[0])).isEmpty();
        }
        finally {
            electionEventHandler.failIfErrorEventHappened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testExceptionForwarding() throws Exception {
        CreateBuilder mockCreateBuilder = (CreateBuilder)Mockito.mock(CreateBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Exception testException = new Exception("Test exception");
        try (CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)this.configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);){
            CuratorFramework client = (CuratorFramework)Mockito.spy((Object)curatorFrameworkWrapper.asCuratorFramework());
            ((CuratorFramework)Mockito.doAnswer(invocation -> mockCreateBuilder).when((Object)client)).create();
            Mockito.when((Object)((String)((ACLBackgroundPathAndBytesable)mockCreateBuilder.creatingParentsIfNeeded().withMode((CreateMode)ArgumentMatchers.any(CreateMode.class))).forPath(Mockito.anyString(), (byte[])Mockito.any(byte[].class)))).thenThrow(new Throwable[]{testException});
            TestingLeaderElectionListener electionEventHandler = new TestingLeaderElectionListener();
            try (ZooKeeperLeaderElectionDriver leaderElectionDriver = this.createAndInitLeaderElectionDriver(client, electionEventHandler);){
                electionEventHandler.await(LeaderElectionEvent.IsLeaderEvent.class);
                leaderElectionDriver.publishLeaderInformation(COMPONENT_ID, LeaderInformation.known((UUID)UUID.randomUUID(), (String)"some-address"));
                LeaderElectionEvent.ErrorEvent errorEvent = electionEventHandler.await(LeaderElectionEvent.ErrorEvent.class);
                Assertions.assertThat((Throwable)errorEvent.getError()).isEqualTo((Object)testException);
            }
            finally {
                electionEventHandler.failIfErrorEventHappened();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testEphemeralZooKeeperNodes() throws Exception {
        ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = null;
        TestingLeaderElectionListener electionEventHandler = new TestingLeaderElectionListener();
        TestingLeaderRetrievalEventHandler retrievalEventHandler = new TestingLeaderRetrievalEventHandler();
        CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper2 = null;
        CuratorCache cache = null;
        try {
            CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)this.configuration, (FatalErrorHandler)this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler());
            curatorFrameworkWrapper2 = ZooKeeperUtils.startCuratorFramework((Configuration)this.configuration, (FatalErrorHandler)this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler());
            ZooKeeperLeaderElectionDriver leaderElectionDriver = this.createAndInitLeaderElectionDriver(curatorFrameworkWrapper.asCuratorFramework(), electionEventHandler);
            leaderRetrievalDriver = ZooKeeperUtils.createLeaderRetrievalDriverFactory((CuratorFramework)curatorFrameworkWrapper2.asCuratorFramework(), (String)COMPONENT_ID).createLeaderRetrievalDriver((LeaderRetrievalEventHandler)retrievalEventHandler, retrievalEventHandler::handleError);
            cache = CuratorCache.build((CuratorFramework)curatorFrameworkWrapper2.asCuratorFramework(), (String)ZooKeeperUtils.generateConnectionInformationPath((String)COMPONENT_ID), (CuratorCache.Options[])new CuratorCache.Options[0]);
            ExistsCacheListener existsListener = ExistsCacheListener.createWithNodeIsMissingValidation(cache, ZooKeeperUtils.generateConnectionInformationPath((String)COMPONENT_ID));
            cache.listenable().addListener((Object)existsListener);
            cache.start();
            electionEventHandler.await(LeaderElectionEvent.IsLeaderEvent.class);
            leaderElectionDriver.publishLeaderInformation(COMPONENT_ID, LeaderInformation.known((UUID)UUID.randomUUID(), (String)LEADER_ADDRESS));
            retrievalEventHandler.waitForNewLeader();
            Future<Boolean> existsFuture = existsListener.nodeExists();
            existsFuture.get(200000L, TimeUnit.MILLISECONDS);
            DeletedCacheListener deletedCacheListener = DeletedCacheListener.createWithNodeExistValidation(cache, ZooKeeperUtils.generateConnectionInformationPath((String)COMPONENT_ID));
            cache.listenable().addListener((Object)deletedCacheListener);
            leaderElectionDriver.close();
            curatorFrameworkWrapper.close();
            Future<Boolean> deletedFuture = deletedCacheListener.nodeDeleted();
            deletedFuture.get(200000L, TimeUnit.MILLISECONDS);
            retrievalEventHandler.waitForEmptyLeaderInformation();
        }
        finally {
            if (leaderRetrievalDriver != null) {
                leaderRetrievalDriver.close();
            }
            if (cache != null) {
                cache.close();
            }
            if (curatorFrameworkWrapper2 != null) {
                curatorFrameworkWrapper2.close();
            }
            electionEventHandler.failIfErrorEventHappened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNotLeaderShouldNotCleanUpTheLeaderInformation() throws Exception {
        TestingLeaderElectionListener electionEventHandler = new TestingLeaderElectionListener();
        TestingLeaderRetrievalEventHandler retrievalEventHandler = new TestingLeaderRetrievalEventHandler();
        try (ZooKeeperLeaderElectionDriver leaderElectionDriver = this.createAndInitLeaderElectionDriver(this.createZooKeeperClient(), electionEventHandler);){
            electionEventHandler.await(LeaderElectionEvent.IsLeaderEvent.class);
            UUID leaderSessionID = UUID.randomUUID();
            leaderElectionDriver.publishLeaderInformation(COMPONENT_ID, LeaderInformation.known((UUID)leaderSessionID, (String)LEADER_ADDRESS));
            leaderElectionDriver.notLeader();
            electionEventHandler.await(LeaderElectionEvent.NotLeaderEvent.class);
            try (ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = ZooKeeperUtils.createLeaderRetrievalDriverFactory((CuratorFramework)this.createZooKeeperClient(), (String)COMPONENT_ID).createLeaderRetrievalDriver((LeaderRetrievalEventHandler)retrievalEventHandler, retrievalEventHandler::handleError);){
                retrievalEventHandler.waitForNewLeader();
                Assertions.assertThat((Comparable)retrievalEventHandler.getLeaderSessionID()).isEqualTo((Object)leaderSessionID);
                Assertions.assertThat((String)retrievalEventHandler.getAddress()).isEqualTo(LEADER_ADDRESS);
            }
        }
        finally {
            electionEventHandler.failIfErrorEventHappened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnExpectedErrorForwarding() throws Exception {
        ZooKeeperLeaderElectionDriver leaderElectionDriver = null;
        TestingLeaderElectionListener electionEventHandler = new TestingLeaderElectionListener();
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        final FlinkRuntimeException testException = new FlinkRuntimeException("testUnExpectedErrorForwarding");
        CuratorFrameworkFactory.Builder curatorFrameworkBuilder = CuratorFrameworkFactory.builder().connectString(((ZooKeeperExtension)this.zooKeeperResource.getCustomExtension()).getConnectString()).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(1, 10, 0)).aclProvider(new ACLProvider(){

            public List<ACL> getDefaultAcl() {
                throw testException;
            }

            public List<ACL> getAclForPath(String s) {
                throw testException;
            }
        }).namespace("flink");
        try (CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((CuratorFrameworkFactory.Builder)curatorFrameworkBuilder, (FatalErrorHandler)fatalErrorHandler);){
            CuratorFramework clientWithErrorHandler = curatorFrameworkWrapper.asCuratorFramework();
            Assertions.assertThat(fatalErrorHandler.getErrorFuture()).isNotDone();
            leaderElectionDriver = this.createAndInitLeaderElectionDriver(clientWithErrorHandler, electionEventHandler);
            Assertions.assertThat((Throwable)fatalErrorHandler.getErrorFuture().get()).isEqualTo((Object)testException);
        }
        finally {
            if (leaderElectionDriver != null) {
                leaderElectionDriver.close();
            }
            electionEventHandler.failIfErrorEventHappened();
        }
    }

    private CuratorFramework createZooKeeperClient() {
        return ((ZooKeeperExtension)this.zooKeeperResource.getCustomExtension()).getZooKeeperClient(this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler());
    }

    private ZooKeeperLeaderElectionDriver createAndInitLeaderElectionDriver(CuratorFramework client, TestingLeaderElectionListener electionEventHandler) throws Exception {
        return new ZooKeeperLeaderElectionDriverFactory(client).create((LeaderElectionDriver.Listener)electionEventHandler);
    }

    private static class DeletedCacheListener
    implements CuratorCacheListener {
        final CompletableFuture<Boolean> deletedPromise = new CompletableFuture();
        final CuratorCache cache;

        public static DeletedCacheListener createWithNodeExistValidation(CuratorCache cache, String path) {
            Preconditions.checkState((boolean)cache.get(path).isPresent(), (String)"The given path %s should lead to an already existing node. This listener will then check that the node was properly deleted.", (Object[])new Object[]{path});
            return new DeletedCacheListener(cache);
        }

        private DeletedCacheListener(CuratorCache cache) {
            this.cache = cache;
        }

        public Future<Boolean> nodeDeleted() {
            return this.deletedPromise;
        }

        public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
            if (!(type != CuratorCacheListener.Type.NODE_DELETED && data != null || this.deletedPromise.isDone())) {
                this.deletedPromise.complete(true);
                this.cache.listenable().removeListener((Object)this);
            }
        }
    }

    private static class ExistsCacheListener
    implements CuratorCacheListener {
        final CompletableFuture<Boolean> existsPromise = new CompletableFuture();
        final CuratorCache cache;

        public static ExistsCacheListener createWithNodeIsMissingValidation(CuratorCache cache, String path) {
            Preconditions.checkState((!cache.get(path).isPresent() ? 1 : 0) != 0, (String)"The given path %s should not lead to an already existing node. This listener will then check that the node was created.", (Object[])new Object[]{path});
            return new ExistsCacheListener(cache);
        }

        private ExistsCacheListener(CuratorCache cache) {
            this.cache = cache;
        }

        public Future<Boolean> nodeExists() {
            return this.existsPromise;
        }

        public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
            if (type == CuratorCacheListener.Type.NODE_CREATED && data != null && !this.existsPromise.isDone()) {
                this.existsPromise.complete(true);
                this.cache.listenable().removeListener((Object)this);
            }
        }
    }
}

