/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.TasksBalancedRequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.runtime.scheduler.loading.DefaultLoadingWeight;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class PreferredAllocationRequestSlotMatchingStrategyTest {
    private static final ResourceProfile finedGrainProfile = ResourceProfile.newBuilder().setCpuCores(1.0).build();
    private static final AllocationID allocationId1 = new AllocationID();
    private static final AllocationID allocationId2 = new AllocationID();
    private static final TaskManagerLocation tmLocation1 = new LocalTaskManagerLocation();
    private static final TaskManagerLocation tmLocation2 = new LocalTaskManagerLocation();
    private static final TestingPhysicalSlot slot1OfTm1 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(ResourceProfile.ANY, allocationId1, tmLocation1);
    private static final TestingPhysicalSlot slot2OfTm1 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndAnyProfile(tmLocation1);
    private static final TestingPhysicalSlot slot3OfTm1 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndAnyProfile(tmLocation1);
    private static final TestingPhysicalSlot slot4OfTm1 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndGrainProfile(tmLocation1);
    private static final TestingPhysicalSlot slot5OfTm1 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndGrainProfile(tmLocation1);
    private static final TestingPhysicalSlot slot6OfTm2 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(finedGrainProfile, allocationId2, tmLocation2);
    private static final TestingPhysicalSlot slot7OfTm2 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndAnyProfile(tmLocation2);
    private static final TestingPhysicalSlot slot8OfTm2 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndAnyProfile(tmLocation2);
    private static final TestingPhysicalSlot slot9OfTm2 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndGrainProfile(tmLocation2);
    private static final TestingPhysicalSlot slot10OfTm2 = PreferredAllocationRequestSlotMatchingStrategyTest.createSlotAndGrainProfile(tmLocation2);
    private static final PendingRequest request1 = PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(2.0f, allocationId1);
    private static final PendingRequest request2 = PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(finedGrainProfile, 3.0f, allocationId2);
    private static final PendingRequest request3 = PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(2.0f, null);
    private static final PendingRequest request4 = PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(1.0f, null);
    private static final PendingRequest request5 = PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(finedGrainProfile, 3.0f, null);
    private static final PendingRequest request6 = PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(finedGrainProfile, 5.0f, null);

    PreferredAllocationRequestSlotMatchingStrategyTest() {
    }

    @Test
    void testNewSlotsAreMatchedAgainstPreferredAllocationIDs() {
        RequestSlotMatchingStrategy strategy = PreferredAllocationRequestSlotMatchingStrategy.create((RequestSlotMatchingStrategy)SimpleRequestSlotMatchingStrategy.INSTANCE);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        List<TestingPhysicalSlot> slots = Arrays.asList(TestingPhysicalSlot.builder().withAllocationID(allocationId1).build(), TestingPhysicalSlot.builder().withAllocationID(allocationId2).build());
        List<PendingRequest> pendingRequests = Arrays.asList(PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)ResourceProfile.UNKNOWN, (LoadingWeight)DefaultLoadingWeight.EMPTY, Collections.singleton(allocationId2)), PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)ResourceProfile.UNKNOWN, (LoadingWeight)DefaultLoadingWeight.EMPTY, Collections.singleton(allocationId1)));
        Collection requestSlotMatches = strategy.matchRequestsAndSlots(slots, pendingRequests, new HashMap());
        Assertions.assertThat((Collection)requestSlotMatches).hasSize(2);
        for (RequestSlotMatchingStrategy.RequestSlotMatch requestSlotMatch : requestSlotMatches) {
            Assertions.assertThat((Collection)requestSlotMatch.getPendingRequest().getPreferredAllocations()).contains((Object[])new AllocationID[]{requestSlotMatch.getSlot().getAllocationId()});
        }
    }

    @Test
    void testNewSlotsAreMatchedAgainstAllocationAndBalancedPreferredIDs() {
        RequestSlotMatchingStrategy strategy = PreferredAllocationRequestSlotMatchingStrategy.create((RequestSlotMatchingStrategy)TasksBalancedRequestSlotMatchingStrategy.INSTANCE);
        List<PendingRequest> pendingRequests = Arrays.asList(request1, request2, request3, request4, request5, request6);
        List<TestingPhysicalSlot> slots = PreferredAllocationRequestSlotMatchingStrategyTest.getSlots();
        Collection requestSlotMatches = strategy.matchRequestsAndSlots(slots, pendingRequests, new HashMap());
        Map<TaskManagerLocation, List<SlotRequestId>> expectedResult = PreferredAllocationRequestSlotMatchingStrategyTest.getExpectedResult();
        Assertions.assertThat((Collection)requestSlotMatches).hasSize(6);
        expectedResult.forEach((taskManagerLocation, slotRequestIds) -> {
            List requestIdsOfTm = requestSlotMatches.stream().filter(requestSlotMatch -> requestSlotMatch.getSlot().getTaskManagerLocation().equals(taskManagerLocation)).map(requestSlotMatch -> requestSlotMatch.getPendingRequest().getSlotRequestId()).collect(Collectors.toList());
            Assertions.assertThat(requestIdsOfTm).containsAll((Iterable)slotRequestIds);
        });
    }

    private static Map<TaskManagerLocation, List<SlotRequestId>> getExpectedResult() {
        HashMap<TaskManagerLocation, List<SlotRequestId>> expectedResult = new HashMap<TaskManagerLocation, List<SlotRequestId>>(2);
        expectedResult.put(tmLocation1, Arrays.asList(request1.getSlotRequestId(), request6.getSlotRequestId(), request4.getSlotRequestId()));
        expectedResult.put(tmLocation2, Arrays.asList(request2.getSlotRequestId(), request5.getSlotRequestId(), request3.getSlotRequestId()));
        return expectedResult;
    }

    private static List<TestingPhysicalSlot> getSlots() {
        return Arrays.asList(slot1OfTm1, slot2OfTm1, slot3OfTm1, slot4OfTm1, slot5OfTm1, slot6OfTm2, slot7OfTm2, slot8OfTm2, slot9OfTm2, slot10OfTm2);
    }

    private static PendingRequest createRequest(ResourceProfile requestProfile, float loading, @Nullable AllocationID preferAllocationId) {
        List<Object> preferAllocationIds = Objects.isNull(preferAllocationId) ? Collections.emptyList() : Collections.singletonList(preferAllocationId);
        return PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)requestProfile, (LoadingWeight)new DefaultLoadingWeight(loading), preferAllocationIds);
    }

    private static PendingRequest createRequest(float loading, @Nullable AllocationID preferAllocationId) {
        return PreferredAllocationRequestSlotMatchingStrategyTest.createRequest(ResourceProfile.UNKNOWN, loading, preferAllocationId);
    }

    private static TestingPhysicalSlot createSlotAndAnyProfile(TaskManagerLocation tmLocation) {
        return PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(ResourceProfile.ANY, new AllocationID(), tmLocation);
    }

    private static TestingPhysicalSlot createSlotAndGrainProfile(TaskManagerLocation tmLocation) {
        return PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(finedGrainProfile, new AllocationID(), tmLocation);
    }

    private static TestingPhysicalSlot createSlot(ResourceProfile profile, AllocationID allocationId, TaskManagerLocation tmLocation) {
        return TestingPhysicalSlot.builder().withAllocationID(allocationId).withTaskManagerLocation(tmLocation).withResourceProfile(profile).build();
    }
}

