/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.cleanup;

import java.time.Duration;
import org.apache.flink.configuration.CleanupOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.cleanup.CleanupRetryStrategyFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExponentialBackoffRetryStrategy;
import org.apache.flink.util.concurrent.FixedRetryStrategy;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class CleanupRetryStrategyFactoryTest {
    private static final CleanupRetryStrategyFactory TEST_INSTANCE = CleanupRetryStrategyFactory.INSTANCE;

    CleanupRetryStrategyFactoryTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"none", "disable", "off", "NONE", "None", "oFf"})
    public void testNoRetryStrategyCreation(String configValue) {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy(configValue);
        RetryStrategy retryStrategy = TEST_INSTANCE.createRetryStrategy(config);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isZero();
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isZero();
    }

    @ParameterizedTest
    @ValueSource(strings={"", "random string"})
    public void testInvalidConfiguration(String value) {
        Assertions.assertThatThrownBy(() -> TEST_INSTANCE.createRetryStrategy(CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy(value)));
    }

    @Test
    public void testDefaultStrategyCreation() {
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyCreation(new Configuration(), (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue(), (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue(), (Integer)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS.defaultValue());
    }

    private static Configuration createConfigurationWithRetryStrategy(String configValue) {
        Configuration config = new Configuration();
        config.set(CleanupOptions.CLEANUP_STRATEGY, (Object)configValue);
        return config;
    }

    @Test
    public void testFixedDelayStrategyCreationWithFixedDelayStrategyDefaultLabel() {
        CleanupRetryStrategyFactoryTest.testFixedDelayStrategyWithDefaultValues("fixed-delay");
    }

    @Test
    public void testFixedDelayStrategyCreationWithAlphaNumericFixedDelayStrategyLabel() {
        CleanupRetryStrategyFactoryTest.testFixedDelayStrategyWithDefaultValues(CleanupOptions.extractAlphaNumericCharacters((String)"fixed-delay"));
    }

    private static void testFixedDelayStrategyWithDefaultValues(String label) {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy(label);
        CleanupRetryStrategyFactoryTest.testFixedDelayStrategyCreation(config, (Duration)CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_DELAY.defaultValue(), (Integer)CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_ATTEMPTS.defaultValue());
    }

    @Test
    public void testFixedDelayStrategyWithCustomDelay() {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy("fixed-delay");
        Duration customDelay = ((Duration)CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_DELAY.defaultValue()).plusMinutes(1L);
        config.set(CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_DELAY, (Object)customDelay);
        CleanupRetryStrategyFactoryTest.testFixedDelayStrategyCreation(config, customDelay, (Integer)CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_ATTEMPTS.defaultValue());
    }

    @Test
    public void testFixedDelayStrategyWithCustomMaxAttempts() {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy("fixed-delay");
        boolean customMaxAttempts = true;
        Preconditions.checkArgument((1 != (Integer)CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_ATTEMPTS.defaultValue() ? 1 : 0) != 0, (Object)"The custom value should be different from the default value to make it possible that the overwritten value is selected.");
        config.set(CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)1);
        CleanupRetryStrategyFactoryTest.testFixedDelayStrategyCreation(config, (Duration)CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_DELAY.defaultValue(), 1);
    }

    private static void testFixedDelayStrategyCreation(Configuration config, Duration expectedDelay, int expectedMaxAttempts) {
        RetryStrategy retryStrategy = TEST_INSTANCE.createRetryStrategy(config);
        Assertions.assertThat((Object)retryStrategy).isInstanceOf(FixedRetryStrategy.class);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isEqualTo((Object)expectedDelay);
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isEqualTo(expectedMaxAttempts);
    }

    @Test
    public void testExponentialBackoffDelayRetryStrategyCreationWithFixedDelayStrategyDefaultLabel() {
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyWithDefaultValues("exponential-delay");
    }

    @Test
    public void testExponentialBackoffDelayRetryStrategyCreationWithAlphaNumericFixedDelayStrategyLabel() {
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyWithDefaultValues(CleanupOptions.extractAlphaNumericCharacters((String)"exponential-delay"));
    }

    private static void testExponentialBackoffDelayRetryStrategyWithDefaultValues(String label) {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy(label);
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyCreation(config, (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue(), (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue(), (Integer)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS.defaultValue());
    }

    @Test
    public void testExponentialBackoffDelayRetryStrategyWithCustomMinimumDelay() {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy("exponential-delay");
        Duration customMinDelay = ((Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue()).plusMinutes(1L);
        config.set(CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF, (Object)customMinDelay);
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyCreation(config, customMinDelay, (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue(), (Integer)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS.defaultValue());
    }

    @Test
    public void testExponentialBackoffDelayRetryStrategyWithCustomMaximumDelay() {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy("exponential-delay");
        Duration customMaxDelay = ((Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue()).plusMinutes(1L);
        config.set(CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF, (Object)customMaxDelay);
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyCreation(config, (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue(), customMaxDelay, (Integer)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS.defaultValue());
    }

    @Test
    public void testExponentialBackoffDelayRetryStrategyWithCustomMaxAttempts() {
        Configuration config = CleanupRetryStrategyFactoryTest.createConfigurationWithRetryStrategy("exponential-delay");
        int customMaxAttempts = 13;
        Preconditions.checkArgument((13 != (Integer)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS.defaultValue() ? 1 : 0) != 0, (Object)"The custom value should be different from the default value to make it possible that the overwritten value is selected.");
        config.set(CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS, (Object)13);
        CleanupRetryStrategyFactoryTest.testExponentialBackoffDelayRetryStrategyCreation(config, (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue(), (Duration)CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue(), 13);
    }

    private static void testExponentialBackoffDelayRetryStrategyCreation(Configuration config, Duration expectedMinDelay, Duration expectedMaxDelay, int expectedMaxAttempts) {
        RetryStrategy retryStrategy = TEST_INSTANCE.createRetryStrategy(config);
        Assertions.assertThat((Object)retryStrategy).isInstanceOf(ExponentialBackoffRetryStrategy.class);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isEqualTo((Object)expectedMinDelay);
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isEqualTo(expectedMaxAttempts);
        CleanupRetryStrategyFactoryTest.assertMaxDelay(retryStrategy, expectedMaxDelay);
    }

    private static void assertMaxDelay(RetryStrategy retryStrategy, Duration expectedMaximumDelay) {
        RetryStrategy nextInstance = retryStrategy.getNextRetryStrategy();
        Duration currentDuration = retryStrategy.getRetryDelay();
        while (!nextInstance.getRetryDelay().equals(currentDuration)) {
            currentDuration = nextInstance.getRetryDelay();
            nextInstance = nextInstance.getNextRetryStrategy();
        }
        Assertions.assertThat((Duration)currentDuration).isEqualTo((Object)expectedMaximumDelay);
    }
}

