/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.util.Collection;
import java.util.Random;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointMetadataTest {
    CheckpointMetadataTest() {
    }

    @Test
    void testConstructAndDispose() throws Exception {
        Random rnd = new Random();
        long checkpointId = rnd.nextInt(Integer.MAX_VALUE) + 1;
        int numTaskStates = 4;
        int numSubtaskStates = 16;
        int numMasterStates = 7;
        Collection<OperatorState> taskStates = CheckpointTestUtils.createOperatorStates(rnd, null, 4, 0, 0, 16);
        Collection<MasterState> masterStates = CheckpointTestUtils.createRandomMasterStates(rnd, 7);
        CheckpointMetadata checkpoint = new CheckpointMetadata(checkpointId, taskStates, masterStates);
        Assertions.assertThat((long)checkpoint.getCheckpointId()).isEqualTo(checkpointId);
        Assertions.assertThat((Collection)checkpoint.getOperatorStates()).isEqualTo(taskStates);
        Assertions.assertThat((Collection)checkpoint.getMasterStates()).isEqualTo(masterStates);
        Assertions.assertThat((Collection)checkpoint.getOperatorStates()).isNotEmpty();
        Assertions.assertThat((Collection)checkpoint.getMasterStates()).isNotEmpty();
        checkpoint.dispose();
        Assertions.assertThat((Collection)checkpoint.getOperatorStates()).isEmpty();
        Assertions.assertThat((Collection)checkpoint.getMasterStates()).isEmpty();
    }
}

