/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviousAllocationSlotSelectionStrategy
implements SlotSelectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PreviousAllocationSlotSelectionStrategy.class);
    private final SlotSelectionStrategy fallbackSlotSelectionStrategy;

    private PreviousAllocationSlotSelectionStrategy(SlotSelectionStrategy fallbackSlotSelectionStrategy) {
        this.fallbackSlotSelectionStrategy = fallbackSlotSelectionStrategy;
    }

    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull FreeSlotTracker freeSlotTracker, @Nonnull SlotProfile slotProfile) {
        LOG.debug("Select best slot for profile {}.", (Object)slotProfile);
        Collection<AllocationID> priorAllocations = slotProfile.getPreferredAllocations();
        if (!priorAllocations.isEmpty()) {
            for (AllocationID availableSlot : freeSlotTracker.getAvailableSlots()) {
                if (!priorAllocations.contains((Object)availableSlot)) continue;
                return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(freeSlotTracker.getSlotInfo(availableSlot), Locality.LOCAL));
            }
        }
        return this.fallbackSlotSelectionStrategy.selectBestSlotForProfile(freeSlotTracker.createNewFreeSlotTrackerWithoutBlockedSlots(slotProfile.getReservedAllocations()), slotProfile);
    }

    public static PreviousAllocationSlotSelectionStrategy create() {
        return PreviousAllocationSlotSelectionStrategy.create(LocationPreferenceSlotSelectionStrategy.createDefault());
    }

    public static PreviousAllocationSlotSelectionStrategy create(SlotSelectionStrategy fallbackSlotSelectionStrategy) {
        return new PreviousAllocationSlotSelectionStrategy(fallbackSlotSelectionStrategy);
    }
}

