/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.Collection;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class SlotProfile {
    private final ResourceProfile taskResourceProfile;
    private final ResourceProfile physicalSlotResourceProfile;
    private final Collection<TaskManagerLocation> preferredLocations;
    private final Collection<AllocationID> preferredAllocations;
    private final Set<AllocationID> reservedAllocations;

    private SlotProfile(ResourceProfile taskResourceProfile, ResourceProfile physicalSlotResourceProfile, Collection<TaskManagerLocation> preferredLocations, Collection<AllocationID> preferredAllocations, Set<AllocationID> reservedAllocations) {
        this.taskResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)taskResourceProfile);
        this.physicalSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)physicalSlotResourceProfile);
        this.preferredLocations = (Collection)Preconditions.checkNotNull(preferredLocations);
        this.preferredAllocations = (Collection)Preconditions.checkNotNull(preferredAllocations);
        this.reservedAllocations = (Set)Preconditions.checkNotNull(reservedAllocations);
    }

    public ResourceProfile getTaskResourceProfile() {
        return this.taskResourceProfile;
    }

    public ResourceProfile getPhysicalSlotResourceProfile() {
        return this.physicalSlotResourceProfile;
    }

    public Collection<TaskManagerLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    public Collection<AllocationID> getPreferredAllocations() {
        return this.preferredAllocations;
    }

    public Set<AllocationID> getReservedAllocations() {
        return this.reservedAllocations;
    }

    public static SlotProfile priorAllocation(ResourceProfile taskResourceProfile, ResourceProfile physicalSlotResourceProfile, Collection<TaskManagerLocation> preferredLocations, Collection<AllocationID> priorAllocations, Set<AllocationID> reservedAllocations) {
        return new SlotProfile(taskResourceProfile, physicalSlotResourceProfile, preferredLocations, priorAllocations, reservedAllocations);
    }

    public String toString() {
        return "SlotProfile{taskResourceProfile=" + this.taskResourceProfile + ", physicalSlotResourceProfile=" + this.physicalSlotResourceProfile + ", preferredLocations=" + this.preferredLocations + ", preferredAllocations=" + this.preferredAllocations + ", reservedAllocations=" + this.reservedAllocations + "}";
    }
}

