/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.MockOutput;
import org.apache.flink.streaming.util.asyncprocessing.AsyncKeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.util.function.ThrowingConsumer;

public class MockContext<IN, OUT> {
    private List<OUT> outputs;
    private MockOutput<OUT> output;

    public MockContext(Collection<IN> inputs) {
        if (inputs.isEmpty()) {
            throw new RuntimeException("Inputs must not be empty");
        }
        this.outputs = new ArrayList<OUT>();
        this.output = new MockOutput<OUT>(this.outputs);
    }

    public List<OUT> getOutputs() {
        return this.outputs;
    }

    public Output<StreamRecord<OUT>> getOutput() {
        return this.output;
    }

    public static <IN, OUT> List<OUT> createAndExecute(OneInputStreamOperator<IN, OUT> operator, List<IN> inputs) throws Exception {
        return MockContext.createAndExecuteForKeyedStream(operator, inputs, null, null);
    }

    public static <IN, OUT, KEY> List<OUT> createAndExecuteForKeyedStream(OneInputStreamOperator<IN, OUT> operator, List<IN> inputs, KeySelector<IN, KEY> keySelector, TypeInformation<KEY> keyType) throws Exception {
        ThrowingConsumer consumer;
        KeyedOneInputStreamOperatorTestHarness testHarness;
        if (operator instanceof AbstractAsyncStateStreamOperator) {
            testHarness = AsyncKeyedOneInputStreamOperatorTestHarness.create(operator, keySelector, keyType);
            consumer = in -> ((AsyncKeyedOneInputStreamOperatorTestHarness)testHarness).processElement(in);
        } else {
            testHarness = new KeyedOneInputStreamOperatorTestHarness<KEY, IN, OUT>(operator, keySelector, keyType);
            consumer = in -> ((KeyedOneInputStreamOperatorTestHarness)testHarness).processElement(in);
        }
        testHarness.setup();
        testHarness.open();
        operator.open();
        for (IN in2 : inputs) {
            consumer.accept((Object)new StreamRecord(in2));
        }
        testHarness.close();
        ConcurrentLinkedQueue<Object> output = testHarness.getOutput();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : output) {
            if (!(o instanceof StreamRecord)) continue;
            result.add(((StreamRecord)o).getValue());
        }
        return result;
    }
}

