/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.v2.RegisteredKeyAndUserKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.v2.RegisteredKeyValueStateBackendMetaInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegisteredKeyValueStateBackendMetaInfoV2Test {
    @Test
    void testRegisteredKeyValueStateBackendMetaInfoV2SerializationRoundtrip() throws Exception {
        byte[] serialized;
        IntSerializer keySerializer = IntSerializer.INSTANCE;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        StringSerializer userKeySerializer = StringSerializer.INSTANCE;
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoList = new ArrayList<StateMetaInfoSnapshot>();
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo("a", StateDescriptor.Type.VALUE, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyAndUserKeyValueStateBackendMetaInfo("b", StateDescriptor.Type.MAP, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer, (TypeSerializer)userKeySerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo("c", StateDescriptor.Type.VALUE, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy((TypeSerializer)keySerializer, stateMetaInfoList, true);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new KeyedBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        Assertions.assertThat((boolean)serializationProxy.isUsingKeyGroupCompression()).isTrue();
        Assertions.assertThat((Object)serializationProxy.getKeySerializerSnapshot()).isInstanceOf(IntSerializer.IntSerializerSnapshot.class);
        this.assertEqualStateMetaInfoSnapshotsLists(stateMetaInfoList, serializationProxy.getStateMetaInfoSnapshots());
    }

    @Test
    void testMapKeyedStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        IntSerializer keySerializer = IntSerializer.INSTANCE;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        StringSerializer userKeySerializer = StringSerializer.INSTANCE;
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoList = new ArrayList<StateMetaInfoSnapshot>();
        StateMetaInfoSnapshot oldStateMeta = new RegisteredKeyValueStateBackendMetaInfo("test1", StateDescriptor.Type.MAP, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot();
        StateMetaInfoSnapshot oldStateMetaWithUserKey = new RegisteredKeyAndUserKeyValueStateBackendMetaInfo("test2", StateDescriptor.Type.MAP, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer, (TypeSerializer)userKeySerializer).snapshot();
        stateMetaInfoList.add(oldStateMeta);
        stateMetaInfoList.add(oldStateMetaWithUserKey);
        Assertions.assertThat((Comparable)oldStateMeta.getBackendStateType()).isEqualTo((Object)StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2);
        Assertions.assertThat((Comparable)oldStateMetaWithUserKey.getBackendStateType()).isEqualTo((Object)StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2);
        Assertions.assertThat((Object)oldStateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.USER_KEY_SERIALIZER)).isNull();
        Assertions.assertThat((Object)oldStateMetaWithUserKey.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.USER_KEY_SERIALIZER).restoreSerializer()).isEqualTo((Object)userKeySerializer);
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy((TypeSerializer)keySerializer, stateMetaInfoList, true);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new KeyedBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        List stateMetaInfoSnapshots = serializationProxy.getStateMetaInfoSnapshots();
        RegisteredKeyValueStateBackendMetaInfo restoredMetaInfo = (RegisteredKeyValueStateBackendMetaInfo)RegisteredStateMetaInfoBase.fromMetaInfoSnapshot((StateMetaInfoSnapshot)((StateMetaInfoSnapshot)stateMetaInfoSnapshots.get(0)));
        Assertions.assertThat(restoredMetaInfo.getClass()).isEqualTo(RegisteredKeyAndUserKeyValueStateBackendMetaInfo.class);
        Assertions.assertThat((String)restoredMetaInfo.getName()).isEqualTo("test1");
        Assertions.assertThat((Object)((RegisteredKeyAndUserKeyValueStateBackendMetaInfo)restoredMetaInfo).getUserKeySerializer()).isNull();
        Assertions.assertThat((Object)restoredMetaInfo.getStateSerializer()).isEqualTo((Object)DoubleSerializer.INSTANCE);
        Assertions.assertThat((Object)restoredMetaInfo.getNamespaceSerializer()).isEqualTo((Object)LongSerializer.INSTANCE);
        RegisteredKeyValueStateBackendMetaInfo restoredMetaInfo1 = (RegisteredKeyValueStateBackendMetaInfo)RegisteredStateMetaInfoBase.fromMetaInfoSnapshot((StateMetaInfoSnapshot)((StateMetaInfoSnapshot)stateMetaInfoSnapshots.get(1)));
        Assertions.assertThat(restoredMetaInfo1.getClass()).isEqualTo(RegisteredKeyAndUserKeyValueStateBackendMetaInfo.class);
        Assertions.assertThat((String)restoredMetaInfo1.getName()).isEqualTo("test2");
        Assertions.assertThat((Object)((RegisteredKeyAndUserKeyValueStateBackendMetaInfo)restoredMetaInfo1).getUserKeySerializer()).isEqualTo((Object)StringSerializer.INSTANCE);
        Assertions.assertThat((Object)restoredMetaInfo1.getStateSerializer()).isEqualTo((Object)DoubleSerializer.INSTANCE);
        Assertions.assertThat((Object)restoredMetaInfo1.getNamespaceSerializer()).isEqualTo((Object)LongSerializer.INSTANCE);
    }

    private void assertEqualStateMetaInfoSnapshotsLists(List<StateMetaInfoSnapshot> expected, List<StateMetaInfoSnapshot> actual) {
        Assertions.assertThat(actual).hasSameSizeAs(expected);
        for (int i = 0; i < expected.size(); ++i) {
            this.assertEqualStateMetaInfoSnapshots(expected.get(i), actual.get(i));
        }
    }

    private void assertEqualStateMetaInfoSnapshots(StateMetaInfoSnapshot expected, StateMetaInfoSnapshot actual) {
        Assertions.assertThat((String)actual.getName()).isEqualTo(expected.getName());
        Assertions.assertThat((Comparable)actual.getBackendStateType()).isEqualTo((Object)expected.getBackendStateType());
        Assertions.assertThat((Map)actual.getOptionsImmutable()).isEqualTo((Object)expected.getOptionsImmutable());
        Assertions.assertThat((Map)actual.getSerializerSnapshotsImmutable()).isEqualTo((Object)expected.getSerializerSnapshotsImmutable());
    }
}

