/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntryMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.FailureHandlingResultSnapshot;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterables;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class RootExceptionHistoryEntryTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();
    private ExecutionGraph executionGraph;

    RootExceptionHistoryEntryTest() {
    }

    @BeforeEach
    void setup() throws JobException, JobExecutionException {
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        jobGraph.getVertices().forEach(v -> v.setParallelism(3));
        this.executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).build((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        this.executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
    }

    @Test
    void testFromFailureHandlingResultSnapshot() throws ExecutionException, InterruptedException {
        RuntimeException rootException = new RuntimeException("Expected root failure");
        ExecutionVertex rootExecutionVertex = this.extractExecutionVertex(0);
        long rootTimestamp = this.triggerFailure(rootExecutionVertex, rootException);
        CompletableFuture<Map<String, String>> rootFailureLabels = CompletableFuture.completedFuture(Collections.singletonMap("key", "value"));
        IllegalStateException concurrentException1 = new IllegalStateException("Expected other failure1");
        ExecutionVertex concurrentlyFailedExecutionVertex1 = this.extractExecutionVertex(1);
        Predicate<ExceptionHistoryEntry> exception1Predicate = this.triggerFailureAndCreateEntryMatcher(concurrentException1, concurrentlyFailedExecutionVertex1);
        FailureHandlingResultSnapshot snapshot = new FailureHandlingResultSnapshot(rootExecutionVertex.getCurrentExecutionAttempt(), (Throwable)rootException, rootTimestamp, rootFailureLabels, Collections.singleton(concurrentlyFailedExecutionVertex1.getCurrentExecutionAttempt()), true);
        RootExceptionHistoryEntry actualEntry = RootExceptionHistoryEntry.fromFailureHandlingResultSnapshot((FailureHandlingResultSnapshot)snapshot);
        Assertions.assertThat((Object)actualEntry).matches(ExceptionHistoryEntryMatcher.matchesFailure(rootException, rootTimestamp, rootFailureLabels.get(), rootExecutionVertex.getTaskNameWithSubtaskIndex(), rootExecutionVertex.getCurrentAssignedResourceLocation()));
        ((IterableAssert)Assertions.assertThat((Iterable)actualEntry.getConcurrentExceptions()).hasSize(1)).allMatch(exception1Predicate);
        IllegalStateException concurrentException2 = new IllegalStateException("Expected other failure2");
        ExecutionVertex concurrentlyFailedExecutionVertex2 = this.extractExecutionVertex(2);
        Predicate<ExceptionHistoryEntry> exception2Predicate = this.triggerFailureAndCreateEntryMatcher(concurrentException2, concurrentlyFailedExecutionVertex2);
        actualEntry.addConcurrentExceptions((Iterable)concurrentlyFailedExecutionVertex2.getCurrentExecutions());
        ((IterableAssert)Assertions.assertThat((Iterable)actualEntry.getConcurrentExceptions()).hasSize(2)).allMatch(exceptionHistoryEntry -> exception1Predicate.test((ExceptionHistoryEntry)exceptionHistoryEntry) || exception2Predicate.test((ExceptionHistoryEntry)exceptionHistoryEntry));
    }

    @Test
    void testFromGlobalFailure() throws ExecutionException, InterruptedException {
        RuntimeException concurrentException0 = new RuntimeException("Expected concurrent failure #0");
        ExecutionVertex concurrentlyFailedExecutionVertex0 = this.extractExecutionVertex(0);
        Predicate<ExceptionHistoryEntry> exception0Predicate = this.triggerFailureAndCreateEntryMatcher(concurrentException0, concurrentlyFailedExecutionVertex0);
        IllegalStateException concurrentException1 = new IllegalStateException("Expected concurrent failure #1");
        ExecutionVertex concurrentlyFailedExecutionVertex1 = this.extractExecutionVertex(1);
        Predicate<ExceptionHistoryEntry> exception1Predicate = this.triggerFailureAndCreateEntryMatcher(concurrentException1, concurrentlyFailedExecutionVertex1);
        Exception rootCause = new Exception("Expected root failure");
        long rootTimestamp = System.currentTimeMillis();
        CompletableFuture<Map<String, String>> rootFailureLabels = CompletableFuture.completedFuture(Collections.singletonMap("key", "value"));
        RootExceptionHistoryEntry actualEntry = RootExceptionHistoryEntry.fromGlobalFailure((Throwable)rootCause, (long)rootTimestamp, rootFailureLabels, (Iterable)StreamSupport.stream(this.executionGraph.getAllExecutionVertices().spliterator(), false).map(ExecutionVertex::getCurrentExecutionAttempt).collect(Collectors.toSet()));
        Assertions.assertThat((Object)actualEntry).matches(ExceptionHistoryEntryMatcher.matchesGlobalFailure(rootCause, rootTimestamp, rootFailureLabels.get()));
        Assertions.assertThat((Iterable)actualEntry.getConcurrentExceptions()).allMatch(exceptionHistoryEntry -> exception0Predicate.test((ExceptionHistoryEntry)exceptionHistoryEntry) || exception1Predicate.test((ExceptionHistoryEntry)exceptionHistoryEntry));
    }

    private Predicate<ExceptionHistoryEntry> triggerFailureAndCreateEntryMatcher(Throwable concurrentException0, ExecutionVertex concurrentlyFailedExecutionVertex0) {
        long concurrentExceptionTimestamp0 = this.triggerFailure(concurrentlyFailedExecutionVertex0, concurrentException0);
        return ExceptionHistoryEntryMatcher.matchesFailure(concurrentException0, concurrentExceptionTimestamp0, concurrentlyFailedExecutionVertex0.getTaskNameWithSubtaskIndex(), concurrentlyFailedExecutionVertex0.getCurrentAssignedResourceLocation());
    }

    private long triggerFailure(ExecutionVertex executionVertex, Throwable throwable) {
        this.executionGraph.updateState(new TaskExecutionStateTransition(new TaskExecutionState(executionVertex.getCurrentExecutionAttempt().getAttemptId(), ExecutionState.FAILED, throwable)));
        return ((ErrorInfo)executionVertex.getFailureInfo().orElseThrow(() -> new IllegalArgumentException("The transition into failed state didn't succeed for ExecutionVertex " + executionVertex.getID() + "."))).getTimestamp();
    }

    private ExecutionVertex extractExecutionVertex(int pos) {
        ExecutionVertex executionVertex = (ExecutionVertex)Iterables.get((Iterable)this.executionGraph.getAllExecutionVertices(), (int)pos);
        executionVertex.tryAssignResource((LogicalSlot)new TestingLogicalSlotBuilder().createTestingLogicalSlot());
        return executionVertex;
    }
}

