/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.logger.NetworkActionsLogger;
import org.apache.flink.runtime.io.network.partition.BufferWritingResultPartition;
import org.apache.flink.runtime.io.network.partition.ChannelStateHolder;
import org.apache.flink.runtime.io.network.partition.CheckpointedResultPartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.consumer.EndOfOutputChannelStateEvent;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class PipelinedResultPartition
extends BufferWritingResultPartition
implements CheckpointedResultPartition,
ChannelStateHolder {
    private static final int PIPELINED_RESULT_PARTITION_ITSELF = -42;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final boolean[] allRecordsProcessedSubpartitions;
    @GuardedBy(value="lock")
    private int numNotAllRecordsProcessedSubpartitions;
    @GuardedBy(value="lock")
    private boolean hasNotifiedEndOfUserRecords;
    @GuardedBy(value="lock")
    private final CompletableFuture<Void> allRecordsProcessedFuture = new CompletableFuture();
    @GuardedBy(value="lock")
    private final boolean[] consumedSubpartitions;
    @GuardedBy(value="lock")
    private int numberOfUsers;

    public PipelinedResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, ResultSubpartition[] subpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, SupplierWithException<BufferPool, IOException> bufferPoolFactory) {
        super(owningTaskName, partitionIndex, partitionId, PipelinedResultPartition.checkResultPartitionType(partitionType), subpartitions, numTargetKeyGroups, partitionManager, bufferCompressor, bufferPoolFactory);
        this.allRecordsProcessedSubpartitions = new boolean[subpartitions.length];
        this.numNotAllRecordsProcessedSubpartitions = subpartitions.length;
        this.consumedSubpartitions = new boolean[subpartitions.length];
        this.numberOfUsers = subpartitions.length + 1;
    }

    @Override
    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        for (ResultSubpartition subpartition : this.subpartitions) {
            if (!(subpartition instanceof ChannelStateHolder)) continue;
            ((PipelinedSubpartition)subpartition).setChannelStateWriter(channelStateWriter);
        }
    }

    @Override
    void onConsumedSubpartition(int subpartitionIndex) {
        this.decrementNumberOfUsers(subpartitionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementNumberOfUsers(int subpartitionIndex) {
        int remainingUnconsumed;
        if (this.isReleased()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (subpartitionIndex != -42) {
                if (this.consumedSubpartitions[subpartitionIndex]) {
                    return;
                }
                this.consumedSubpartitions[subpartitionIndex] = true;
            }
            remainingUnconsumed = --this.numberOfUsers;
        }
        LOG.debug("{}: Received consumed notification for subpartition {}.", (Object)this, (Object)subpartitionIndex);
        if (remainingUnconsumed == 0) {
            this.partitionManager.onConsumedPartition(this);
        } else if (remainingUnconsumed < 0) {
            throw new IllegalStateException("Received consume notification even though all subpartitions are already consumed.");
        }
    }

    @Override
    public ResultSubpartitionInfo getCheckpointedSubpartitionInfo(int subpartitionIndex) {
        return this.subpartitions[subpartitionIndex].getSubpartitionInfo();
    }

    @Override
    public void flushAll() {
        this.flushAllSubpartitions(false);
    }

    @Override
    public void flush(int targetSubpartition) {
        this.flushSubpartition(targetSubpartition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEndOfData(StopMode mode) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.hasNotifiedEndOfUserRecords) {
                this.broadcastEvent(new EndOfData(mode), false);
                this.hasNotifiedEndOfUserRecords = true;
            }
        }
    }

    @Override
    public CompletableFuture<Void> getAllDataProcessedFuture() {
        return this.allRecordsProcessedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubpartitionAllDataProcessed(int subpartition) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allRecordsProcessedSubpartitions[subpartition]) {
                return;
            }
            this.allRecordsProcessedSubpartitions[subpartition] = true;
            --this.numNotAllRecordsProcessedSubpartitions;
            if (this.numNotAllRecordsProcessedSubpartitions == 0) {
                this.allRecordsProcessedFuture.complete(null);
            }
        }
    }

    @Override
    public String toString() {
        return "PipelinedResultPartition " + this.partitionId.toString() + " [" + this.partitionType + ", " + this.subpartitions.length + " subpartitions, " + this.numberOfUsers + " pending consumptions]";
    }

    private static ResultPartitionType checkResultPartitionType(ResultPartitionType type) {
        Preconditions.checkArgument((type == ResultPartitionType.PIPELINED || type == ResultPartitionType.PIPELINED_BOUNDED || type == ResultPartitionType.PIPELINED_APPROXIMATE ? 1 : 0) != 0);
        return type;
    }

    @Override
    public void finishReadRecoveredState(boolean notifyAndBlockOnCompletion) throws IOException {
        if (!notifyAndBlockOnCompletion) {
            return;
        }
        try (BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer(EndOfOutputChannelStateEvent.INSTANCE, false);){
            for (int i = 0; i < this.subpartitions.length; ++i) {
                if (!((PipelinedSubpartition)this.subpartitions[i]).isSupportChannelStateRecover()) continue;
                this.addToSubpartition(i, eventBufferConsumer.copy(), 0);
            }
        }
    }

    @Override
    public BufferBuilder requestBufferBuilderBlocking() throws IOException, RuntimeException, InterruptedException {
        return this.getBufferPool().requestBufferBuilderBlocking();
    }

    @Override
    public void addRecovered(int subpartitionIndex, BufferConsumer bufferConsumer) throws IOException {
        ResultSubpartition subpartition = this.subpartitions[subpartitionIndex];
        NetworkActionsLogger.traceRecover("PipelinedSubpartition#addRecovered", bufferConsumer, this.getOwningTaskName(), subpartition.subpartitionInfo);
        if (this.addToSubpartition(subpartitionIndex, bufferConsumer, Integer.MIN_VALUE) == -1) {
            throw new IOException("Buffer consumer couldn't be added to ResultSubpartition");
        }
    }

    @Override
    public void close() {
        this.decrementNumberOfUsers(-42);
        super.close();
    }
}

