/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.SubchannelClassification;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.remote.FailureDetectorWithAddress;
import org.apache.pekko.remote.HeartbeatHistory;
import org.apache.pekko.remote.HeartbeatHistory$;
import org.apache.pekko.remote.PhiAccrualFailureDetector$State$;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001\u0002\u001f>\u0001\u0019C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0011)A\u0005-\"A!\f\u0001BC\u0002\u0013\u00051\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0007A!b\u0001\n\u0003\t\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011-\u0004!Q1A\u0005\u0002\u0005D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\t[\u0002\u0011)\u0019!C\u0001C\"Aa\u000e\u0001B\u0001B\u0003%!\r\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011!I\bA!A!\u0002\u0017Q\bbBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u001b\u0001A\u0011AA\u0012\u0011\u001d\ti\u0001\u0001C\u0001\u0003gA\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0001\u0004%I!!\u001b\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005\r\u0005\u0002CAH\u0001\u0001\u0006K!a\u001b\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\u001a1\u0011\u0011\u0014\u0001E\u00037C!\"!+\u0019\u0005+\u0007I\u0011AA)\u0011)\tY\u000b\u0007B\tB\u0003%\u00111\u000b\u0005\u000b\u0003[C\"Q3A\u0005\u0002\u0005=\u0006BCAZ1\tE\t\u0015!\u0003\u00022\"9\u0011Q\u0002\r\u0005\u0002\u0005U\u0006\"CA`1\u0005\u0005I\u0011AAa\u0011%\t9\rGI\u0001\n\u0003\tI\rC\u0005\u0002`b\t\n\u0011\"\u0001\u0002b\"I\u0011Q\u001d\r\u0002\u0002\u0013\u0005\u0013q\u001d\u0005\t\u0003oD\u0012\u0011!C\u00017\"I\u0011\u0011 \r\u0002\u0002\u0013\u0005\u00111 \u0005\n\u0005\u000bA\u0012\u0011!C!\u0005\u000fA\u0011B!\u0006\u0019\u0003\u0003%\tAa\u0006\t\u0013\t\u0005\u0002$!A\u0005B\t\r\u0002\"\u0003B\u00131\u0005\u0005I\u0011\tB\u0014\u0011%\u0011I\u0003GA\u0001\n\u0003\u0012YcB\u0005\u00030\u0001\t\t\u0011#\u0003\u00032\u0019I\u0011\u0011\u0014\u0001\u0002\u0002#%!1\u0007\u0005\b\u0003\u001bQC\u0011\u0001B!\u0011%\u0011)CKA\u0001\n\u000b\u00129\u0003C\u0005\u0003D)\n\t\u0011\"!\u0003F!I!1\n\u0016\u0002\u0002\u0013\u0005%Q\n\u0005\n\u00057\u0002!\u0019!C\u0005\u0005;B\u0001B!\u001d\u0001A\u0003%!q\f\u0005\b\u0005g\u0002A\u0011\tB;\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005oBqAa\u001f\u0001\t\u0003\u0012)\bC\u0004\u0003~\u0001!)Ea \t\u000f\t-\u0005\u0001\"\u0005\u0003\u000e\"1!q\u0014\u0001\u0005\u0002UCqAa(\u0001\t\u0013\u0011\t\u000b\u0003\u0005\u0003 \u0002!\ta\u0010BS\u0011!\u0011\u0019\f\u0001b\u0001\n\u0013)\u0006b\u0002B[\u0001\u0001\u0006IA\u0016\u0005\b\u0005o\u0003A\u0011\u0002B]\u0005e\u0001\u0006.[!dGJ,\u0018\r\u001c$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u000b\u0005yz\u0014A\u0002:f[>$XM\u0003\u0002A\u0003\u0006)\u0001/Z6l_*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A$N#B\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\u0004\"AT(\u000e\u0003uJ!\u0001U\u001f\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0004\"A\u0014*\n\u0005Mk$A\u0007$bS2,(/\u001a#fi\u0016\u001cGo\u001c:XSRD\u0017\t\u001a3sKN\u001c\u0018!\u0003;ie\u0016\u001c\bn\u001c7e+\u00051\u0006C\u0001%X\u0013\tA\u0016J\u0001\u0004E_V\u0014G.Z\u0001\u000bi\"\u0014Xm\u001d5pY\u0012\u0004\u0013!D7bqN\u000bW\u000e\u001d7f'&TX-F\u0001]!\tAU,\u0003\u0002_\u0013\n\u0019\u0011J\u001c;\u0002\u001d5\f\u0007pU1na2,7+\u001b>fA\u0005yQ.\u001b8Ti\u0012$UM^5bi&|g.F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0005ekJ\fG/[8o\u0015\t9\u0017*\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001b3\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0001R.\u001b8Ti\u0012$UM^5bi&|g\u000eI\u0001\u0019C\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,\u0017!G1dG\u0016\u0004H/\u00192mK\"+\u0017M\u001d;cK\u0006$\b+Y;tK\u0002\naCZ5sgRDU-\u0019:uE\u0016\fG/R:uS6\fG/Z\u0001\u0018M&\u00148\u000f\u001e%fCJ$(-Z1u\u000bN$\u0018.\\1uK\u0002\n1\"\u001a<f]R\u001cFO]3b[B\u0019\u0001*]:\n\u0005IL%AB(qi&|g\u000e\u0005\u0002uo6\tQO\u0003\u0002w\u007f\u0005)QM^3oi&\u0011\u00010\u001e\u0002\f\u000bZ,g\u000e^*ue\u0016\fW.A\u0003dY>\u001c7\u000eE\u0002|\u0003\u000fq1\u0001`A\u0002\u001d\ri\u0018\u0011\u0001\b\u0003}~l\u0011!Q\u0005\u0003\u0001\u0006K!AP \n\u0007\u0005\u0015Q(A\bGC&dWO]3EKR,7\r^8s\u0013\u0011\tI!a\u0003\u0003\u000b\rcwnY6\u000b\u0007\u0005\u0015Q(\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003#\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011)\u0011\t\u0019\"!\u0006\u0011\u00059\u0003\u0001\"B=\u000e\u0001\bQ\b\"\u0002+\u000e\u0001\u00041\u0006\"\u0002.\u000e\u0001\u0004a\u0006\"\u00021\u000e\u0001\u0004\u0011\u0007\"B6\u000e\u0001\u0004\u0011\u0007\"B7\u000e\u0001\u0004\u0011\u0007\"B8\u000e\u0001\u0004\u0001H\u0003DA\u0013\u0003S\tY#!\f\u00020\u0005EB\u0003BA\n\u0003OAQ!\u001f\bA\u0004iDQ\u0001\u0016\bA\u0002YCQA\u0017\bA\u0002qCQ\u0001\u0019\bA\u0002\tDQa\u001b\bA\u0002\tDQ!\u001c\bA\u0002\t$b!a\u0005\u00026\u0005-\u0003bBA\u001c\u001f\u0001\u0007\u0011\u0011H\u0001\u0007G>tg-[4\u0011\t\u0005m\u0012qI\u0007\u0003\u0003{QA!a\u000e\u0002@)!\u0011\u0011IA\"\u0003!!\u0018\u0010]3tC\u001a,'BAA#\u0003\r\u0019w.\\\u0005\u0005\u0003\u0013\niD\u0001\u0004D_:4\u0017n\u001a\u0005\u0007\u0003\u001bz\u0001\u0019A:\u0002\u0005\u00154\u0018A\u00044jeN$\b*Z1si\n,\u0017\r^\u000b\u0003\u0003'\u00022ATA+\u0013\r\t9&\u0010\u0002\u0011\u0011\u0016\f'\u000f\u001e2fCRD\u0015n\u001d;pef\fqBZ5sgRDU-\u0019:uE\u0016\fG\u000fI\u0001\u001fC\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,W*\u001b7mSN,\"!a\u0018\u0011\u0007!\u000b\t'C\u0002\u0002d%\u0013A\u0001T8oO\u0006y\u0012mY2faR\f'\r\\3IK\u0006\u0014HOY3biB\u000bWo]3NS2d\u0017n\u001d\u0011\u0002\u000f\u0005$GM]3tgV\u0011\u00111\u000e\t\u0005\u0003[\nYH\u0004\u0003\u0002p\u0005]\u0004cAA9\u00136\u0011\u00111\u000f\u0006\u0004\u0003k*\u0015A\u0002\u001fs_>$h(C\u0002\u0002z%\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA?\u0003\u007f\u0012aa\u0015;sS:<'bAA=\u0013\u0006Y\u0011\r\u001a3sKN\u001cx\fJ3r)\u0011\t))a#\u0011\u0007!\u000b9)C\u0002\u0002\n&\u0013A!\u00168ji\"I\u0011QR\u000b\u0002\u0002\u0003\u0007\u00111N\u0001\u0004q\u0012\n\u0014\u0001C1eIJ,7o\u001d\u0011\u0002\u0015M,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0002\u0006\u0006U\u0005bBAL/\u0001\u0007\u00111N\u0001\u0005C\u0012$'OA\u0003Ti\u0006$Xm\u0005\u0004\u0019\u000f\u0006u\u00151\u0015\t\u0004\u0011\u0006}\u0015bAAQ\u0013\n9\u0001K]8ek\u000e$\bc\u0001%\u0002&&\u0019\u0011qU%\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000f!L7\u000f^8ss\u0006A\u0001.[:u_JL\b%A\u0005uS6,7\u000f^1naV\u0011\u0011\u0011\u0017\t\u0005\u0011F\fy&\u0001\u0006uS6,7\u000f^1na\u0002\"b!a.\u0002<\u0006u\u0006cAA]15\t\u0001\u0001C\u0004\u0002*v\u0001\r!a\u0015\t\u000f\u00055V\u00041\u0001\u00022\u0006!1m\u001c9z)\u0019\t9,a1\u0002F\"I\u0011\u0011\u0016\u0010\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u0003[s\u0002\u0013!a\u0001\u0003c\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002L*\"\u00111KAgW\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\u0013Ut7\r[3dW\u0016$'bAAm\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003GTC!!-\u0002N\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!;\u0011\t\u0005-\u0018Q_\u0007\u0003\u0003[TA!a<\u0002r\u0006!A.\u00198h\u0015\t\t\u00190\u0001\u0003kCZ\f\u0017\u0002BA?\u0003[\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002~\n\r\u0001c\u0001%\u0002\u0000&\u0019!\u0011A%\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u000e\u000e\n\t\u00111\u0001]\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0005!\u0019\u0011YA!\u0005\u0002~6\u0011!Q\u0002\u0006\u0004\u0005\u001fI\u0015AC2pY2,7\r^5p]&!!1\u0003B\u0007\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\te!q\u0004\t\u0004\u0011\nm\u0011b\u0001B\u000f\u0013\n9!i\\8mK\u0006t\u0007\"CAGK\u0005\u0005\t\u0019AA\u007f\u0003!A\u0017m\u001d5D_\u0012,G#\u0001/\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!;\u0002\r\u0015\fX/\u00197t)\u0011\u0011IB!\f\t\u0013\u00055\u0005&!AA\u0002\u0005u\u0018!B*uCR,\u0007cAA]UM)!F!\u000e\u0002$BQ!q\u0007B\u001f\u0003'\n\t,a.\u000e\u0005\te\"b\u0001B\u001e\u0013\u00069!/\u001e8uS6,\u0017\u0002\u0002B \u0005s\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011\t$A\u0003baBd\u0017\u0010\u0006\u0004\u00028\n\u001d#\u0011\n\u0005\b\u0003Sk\u0003\u0019AA*\u0011\u001d\ti+\fa\u0001\u0003c\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003P\t]\u0003\u0003\u0002%r\u0005#\u0002r\u0001\u0013B*\u0003'\n\t,C\u0002\u0003V%\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003B-]\u0005\u0005\t\u0019AA\\\u0003\rAH\u0005M\u0001\u0006gR\fG/Z\u000b\u0003\u0005?\u0002bA!\u0019\u0003n\u0005]VB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\r\u0005$x.\\5d\u0015\r9'\u0011\u000e\u0006\u0005\u0005W\n\t0\u0001\u0003vi&d\u0017\u0002\u0002B8\u0005G\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-Z\u0001\u0007gR\fG/\u001a\u0011\u0002\u0017%\u001c\u0018I^1jY\u0006\u0014G.Z\u000b\u0003\u00053!BA!\u0007\u0003z!9\u0011Q\u0016\u001aA\u0002\u0005}\u0013\u0001D5t\u001b>t\u0017\u000e^8sS:<\u0017!\u00035fCJ$(-Z1u)\t\t)\tK\u00025\u0005\u0007\u0003BA!\"\u0003\b6\u0011\u0011q[\u0005\u0005\u0005\u0013\u000b9NA\u0004uC&d'/Z2\u0002\u001dI,7m\u001c:e\u0013:$XM\u001d<bYR!\u00111\u000bBH\u0011\u001d\u0011\t*\u000ea\u0001\u0003?\n\u0001\"\u001b8uKJ4\u0018\r\u001c\u0015\u0004k\tU\u0005\u0003\u0002BL\u00057k!A!'\u000b\u0007\u0005ew(\u0003\u0003\u0003\u001e\ne%aC%oi\u0016\u0014h.\u00197Ba&\f1\u0001\u001d5j)\r1&1\u0015\u0005\b\u0003[;\u0004\u0019AA0)\u001d1&q\u0015BV\u0005_CqA!+9\u0001\u0004\ty&\u0001\u0005uS6,G)\u001b4g\u0011\u0019\u0011i\u000b\u000fa\u0001-\u0006!Q.Z1o\u0011\u0019\u0011\t\f\u000fa\u0001-\u0006a1\u000f\u001e3EKZL\u0017\r^5p]\u0006)R.\u001b8Ti\u0012$UM^5bi&|g.T5mY&\u001c\u0018AF7j]N#H\rR3wS\u0006$\u0018n\u001c8NS2d\u0017n\u001d\u0011\u0002/\u0015t7/\u001e:f-\u0006d\u0017\u000eZ*uI\u0012+g/[1uS>tGc\u0001,\u0003<\"1!\u0011W\u001eA\u0002Y\u0003")
public class PhiAccrualFailureDetector
implements FailureDetector,
FailureDetectorWithAddress {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    private String address() {
        return this.address;
    }

    private void address_$eq(String x$1) {
        this.address = x$1;
    }

    @Override
    public void setAddress(String addr) {
        this.address_$eq(addr);
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                long latestTimestamp = BoxesRunTime.unboxToLong(((Some)option).value());
                long interval = timestamp - latestTimestamp;
                heartbeatHistory = this.isAvailable(timestamp) ? this.recordInterval(interval) : oldState.history();
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, new Some<Object>(BoxesRunTime.boxToLong(timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    @InternalApi
    public HeartbeatHistory recordInterval(long interval) {
        if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
            ((SubchannelClassification)this.eventStream.get()).publish(Logging$Warning$.MODULE$.apply(this.toString(), this.getClass(), new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString(), Logging$.MODULE$.emptyMDC(), RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address())));
        }
        return this.state().get().history().$colon$plus(interval);
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            return 0.0;
        }
        long timeDiff = timestamp - BoxesRunTime.unboxToLong(oldTimestamp.get());
        HeartbeatHistory history = oldState.history();
        double mean = history.mean();
        double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
        return this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -package$.MODULE$.log10(e / (1.0 + e));
        }
        return -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        synchronized (this) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
            return;
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), new Some<EventStream>(ev), FailureDetector$.MODULE$.defaultClock());
    }

    private class State
    implements Product,
    scala.Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        @Override
        public String productPrefix() {
            return "State";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.history();
                }
                case 1: {
                    return this.timestamp();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof State && ((State)x$1).org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() == this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer())) break block3;
                    State state = (State)x$1;
                    HeartbeatHistory heartbeatHistory = this.history();
                    HeartbeatHistory heartbeatHistory2 = state.history();
                    if (heartbeatHistory != null ? !((Object)heartbeatHistory).equals(heartbeatHistory2) : heartbeatHistory2 != null) break block3;
                    Option<Object> option = this.timestamp();
                    Option<Object> option2 = state.timestamp();
                    if ((option != null ? !option.equals(option2) : option2 != null) || !state.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ PhiAccrualFailureDetector org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

