/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Forever$;
import org.apache.pekko.io.dns.CachePolicy$Never$;
import org.apache.pekko.io.dns.CachePolicy$Ttl$;
import org.apache.pekko.io.dns.DnsSettings$;
import org.apache.pekko.io.dns.IdGenerator;
import org.apache.pekko.io.dns.IdGenerator$Policy$EnhancedDoubleHashRandom$;
import org.apache.pekko.io.dns.IdGenerator$Policy$SecureRandom$;
import org.apache.pekko.io.dns.IdGenerator$Policy$ThreadLocalRandom$;
import org.apache.pekko.io.dns.internal.ResolvConf;
import org.apache.pekko.io.dns.internal.ResolvConfParser$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.ccompat.package$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u000f\u001f\u0005yA\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011]\u0002!\u0011!Q\u0001\naBQA\u0011\u0001\u0005\u0002\rCq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004_\u0001\u0001\u0006IA\u0013\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u0019I\u0007\u0001)A\u0005C\"9!\u000e\u0001b\u0001\n\u0003Y\u0007B\u0002>\u0001A\u0003%A\u000eC\u0004|\u0001\t\u0007I\u0011A6\t\rq\u0004\u0001\u0015!\u0003m\u0011!i\b\u0001#b\u0001\n\u0003q\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\u000b\u0003K\u0001\u0001R1A\u0005\n\u0005\u001d\u0002\"CA\u001e\u0001\t\u0007I\u0011AA\u001f\u0011!\t\t\u0005\u0001Q\u0001\n\u0005}\u0002\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u001d\u0003bBA(\u0001\u0011\u0005\u0011\u0011K\u0004\b\u0003Or\u0002\u0012AA5\r\u0019ib\u0004#\u0001\u0002l!1!)\u0006C\u0001\u0003[B\u0011\"a\u001c\u0016\u0005\u0004%i!!\u001d\t\u0011\u0005]T\u0003)A\u0007\u0003gB\u0011\"!\u001f\u0016\u0005\u0004%I!a\u001f\t\u0011\u00055U\u0003)A\u0005\u0003{B\u0001\"a$\u0016\t\u0003\u0011\u0013\u0011\u0013\u0005\t\u00033+B\u0011\u0001\u0012\u0002\u001c\nYAI\\:TKR$\u0018N\\4t\u0015\ty\u0002%A\u0002e]NT!!\t\u0012\u0002\u0005%|'BA\u0012%\u0003\u0015\u0001Xm[6p\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004tsN$X-\\\u0002\u0001!\t\u0011T'D\u00014\u0015\t!$%A\u0003bGR|'/\u0003\u00027g\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u0006\t1\r\u0005\u0002:\u00016\t!H\u0003\u0002<y\u000511m\u001c8gS\u001eT!!\u0010 \u0002\u0011QL\b/Z:bM\u0016T\u0011aP\u0001\u0004G>l\u0017BA!;\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"2\u0001\u0012$H!\t)\u0005!D\u0001\u001f\u0011\u0015y3\u00011\u00012\u0011\u001594\u00011\u00019\u0003-q\u0015-\\3TKJ4XM]:\u0016\u0003)\u00032aS*W\u001d\ta\u0015K\u0004\u0002N!6\taJ\u0003\u0002Pa\u00051AH]8pizJ\u0011\u0001L\u0005\u0003%.\nq\u0001]1dW\u0006<W-\u0003\u0002U+\n!A*[:u\u0015\t\u00116\u0006\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006\u0019a.\u001a;\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018\u0001\u0004(b[\u0016\u001cVM\u001d<feN\u0004\u0013A\u0004*fg>dg/\u001a+j[\u0016|W\u000f^\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\tIV\u0014\u0018\r^5p]*\u0011amK\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00015d\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fqBU3t_24X\rV5nK>,H\u000fI\u0001\u0014!>\u001c\u0018\u000e^5wK\u000e\u000b7\r[3Q_2L7-_\u000b\u0002YB\u0011Qn\u001e\b\u0003]Vt!a\u001c;\u000f\u0005A\u001chBA9s\u001b\u0005!\u0013BA\u0012%\u0013\t\t#%\u0003\u0002 A%\u0011aOH\u0001\f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u00170\u0003\u0002ys\nY1)Y2iKB{G.[2z\u0015\t1h$\u0001\u000bQ_NLG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u0017\u0010I\u0001\u0014\u001d\u0016<\u0017\r^5wK\u000e\u000b7\r[3Q_2L7-_\u0001\u0015\u001d\u0016<\u0017\r^5wK\u000e\u000b7\r[3Q_2L7-\u001f\u0011\u0002#%#w)\u001a8fe\u0006$xN\u001d)pY&\u001c\u00170F\u0001\u0000!\u0011\t\t!a\u0002\u000f\u0007\u0015\u000b\u0019!C\u0002\u0002\u0006y\t1\"\u00133HK:,'/\u0019;pe&!\u0011\u0011BA\u0006\u0005\u0019\u0001v\u000e\\5ds*\u0019\u0011Q\u0001\u0010\u0002\r\u001d,G\u000f\u0016;m)\ra\u0017\u0011\u0003\u0005\b\u0003'i\u0001\u0019AA\u000b\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005]\u0011q\u0004\b\u0005\u00033\tY\u0002\u0005\u0002NW%\u0019\u0011QD\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\tibK\u0001\u000be\u0016\u001cx\u000e\u001c<D_:4WCAA\u0015!\u0015Q\u00131FA\u0018\u0013\r\tic\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e\u001f\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA\u001d\u0003g\u0011!BU3t_248i\u001c8g\u00035\u0019V-\u0019:dQ\u0012{W.Y5ogV\u0011\u0011q\b\t\u0005\u0017N\u000b)\"\u0001\bTK\u0006\u00148\r\u001b#p[\u0006Lgn\u001d\u0011\u0002\u000b9#u\u000e^:\u0016\u0005\u0005\u001d\u0003c\u0001\u0016\u0002J%\u0019\u00111J\u0016\u0003\u0007%sG/\u0001\u0004O\t>$8\u000fI\u0001(M\u0006LG.\u00168bE2,Gk\u001c#fi\u0016\u0014X.\u001b8f\t\u00164\u0017-\u001e7u\u001d\u0006lWm]3sm\u0016\u00148/\u0006\u0002\u0002TA\u0019!&!\u0016\n\u0007\u0005]3FA\u0004O_RD\u0017N\\4)\u0007\u0001\tY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA3\u0003?\u00121\"\u00138uKJt\u0017\r\\!qS\u0006YAI\\:TKR$\u0018N\\4t!\t)Uc\u0005\u0002\u0016SQ\u0011\u0011\u0011N\u0001\u0010\t:\u001ch)\u00197mE\u0006\u001c7\u000eU8siV\u0011\u00111O\b\u0003\u0003kj\u0012!N\u0001\u0011\t:\u001ch)\u00197mE\u0006\u001c7\u000eU8si\u0002\n\u0011#\u001b8fiN{7m[3u\u0003\u0012$'/Z:t+\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u00115\fGo\u00195j]\u001eT1!a\",\u0003\u0011)H/\u001b7\n\t\u0005-\u0015\u0011\u0011\u0002\u0006%\u0016<W\r_\u0001\u0013S:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\b%\u0001\fqCJ\u001cXMT1nKN,'O^3s\u0003\u0012$'/Z:t)\r1\u00161\u0013\u0005\b\u0003+[\u0002\u0019AA\u000b\u0003\r\u0019HO\u001d\u0015\u00047\u0005m\u0013!F4fi\u0012+g-Y;mi:\u000bW.Z*feZ,'o\u001d\u000b\u0005\u0003;\u000b)\u000bE\u0003\u0002 \u0006\u0005&*\u0004\u0002\u0002\u0006&!\u00111UAC\u0005\r!&/\u001f\u0005\u0006_q\u0001\r!\r")
@InternalApi
public final class DnsSettings {
    private IdGenerator.Policy IdGeneratorPolicy;
    private Option<ResolvConf> resolvConf;
    private final ExtendedActorSystem system;
    private final Config c;
    private final List<InetSocketAddress> NameServers;
    private final FiniteDuration ResolveTimeout;
    private final CachePolicy.CachePolicy PositiveCachePolicy;
    private final CachePolicy.CachePolicy NegativeCachePolicy;
    private final List<String> SearchDomains;
    private final int NDots;
    private volatile byte bitmap$0;

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    public CachePolicy.CachePolicy PositiveCachePolicy() {
        return this.PositiveCachePolicy;
    }

    public CachePolicy.CachePolicy NegativeCachePolicy() {
        return this.NegativeCachePolicy;
    }

    private IdGenerator.Policy IdGeneratorPolicy$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                IdGenerator.Policy policy;
                String string = this.c.getString("id-generator-policy");
                if ("thread-local-random".equals(string)) {
                    policy = IdGenerator$Policy$ThreadLocalRandom$.MODULE$;
                } else if ("secure-random".equals(string)) {
                    policy = IdGenerator$Policy$SecureRandom$.MODULE$;
                } else if (string.isEmpty() | string.equals("enhanced-double-hash-random")) {
                    policy = IdGenerator$Policy$EnhancedDoubleHashRandom$.MODULE$;
                } else {
                    throw new IllegalArgumentException(new StringBuilder(137).append("Invalid value for id-generator-policy, id-generator-policy must be 'thread-local-random', 'secure-random' or").append("`enhanced-double-hash-random`").toString());
                }
                this.IdGeneratorPolicy = policy;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.IdGeneratorPolicy;
    }

    public IdGenerator.Policy IdGeneratorPolicy() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.IdGeneratorPolicy$lzycompute();
        }
        return this.IdGeneratorPolicy;
    }

    /*
     * WARNING - void declaration
     */
    private CachePolicy.CachePolicy getTtl(String path) {
        void requiring$extension1_msg;
        void requiring$extension1_$this;
        String string = this.c.getString(path);
        if ("forever".equals(string)) {
            return CachePolicy$Forever$.MODULE$;
        }
        if ("never".equals(string)) {
            return CachePolicy$Never$.MODULE$;
        }
        Function0<String> & Serializable & scala.Serializable intersect = (Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(72).append("pekko.io.dns.").append(path).append(" must be 'default', 'forever', 'never' or positive duration").toString();
        Duration duration = Helpers$.MODULE$.Requiring(this.c.getDuration(path));
        if (Helpers$Requiring$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.require(DnsSettings.$anonfun$getTtl$1((Duration)requiring$extension1_$this), (Function0<Object>)requiring$extension1_msg);
        Duration finiteTtl = (Duration)requiring$extension1_$this;
        return CachePolicy$Ttl$.MODULE$.fromPositive(finiteTtl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<ResolvConf> resolvConf$lzycompute() {
        synchronized (this) {
            Option option;
            if ((byte)(this.bitmap$0 & 2) != 0) return this.resolvConf;
            File etcResolvConf = new File("/etc/resolv.conf");
            if (Helpers$.MODULE$.isWindows()) {
                option = None$.MODULE$;
            } else if (etcResolvConf.exists()) {
                Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                if (parsed instanceof Success) {
                    ResolvConf value = (ResolvConf)((Success)parsed).value();
                    option = new Some<ResolvConf>(value);
                } else {
                    if (!(parsed instanceof Failure)) throw new MatchError(parsed);
                    Throwable exception = ((Failure)parsed).exception();
                    LoggingAdapter log = Logging$.MODULE$.apply(this.system, DnsSettings.class, LogSource$.MODULE$.fromAnyClass());
                    if (log.isWarningEnabled()) {
                        log.error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                    }
                    option = None$.MODULE$;
                }
            } else {
                option = None$.MODULE$;
            }
            this.resolvConf = option;
            this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            return this.resolvConf;
        }
    }

    private Option<ResolvConf> resolvConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolvConf$lzycompute();
        }
        return this.resolvConf;
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `pekko.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    public static final /* synthetic */ boolean $anonfun$getTtl$1(Duration x$2) {
        return !x$2.isNegative();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DnsSettings(ExtendedActorSystem system, Config c) {
        int n;
        List list;
        void asScala$extension_$this;
        List list2;
        this.system = system;
        this.c = c;
        ConfigValueType configValueType = c.getValue("nameservers").valueType();
        if (((Object)((Object)ConfigValueType.STRING)).equals((Object)configValueType)) {
            String string = c.getString("nameservers");
            if ("default".equals(string)) {
                List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> this.failUnableToDetermineDefaultNameservers());
                if (osAddresses.isEmpty()) {
                    throw this.failUnableToDetermineDefaultNameservers();
                }
                list2 = osAddresses;
            } else {
                InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(string);
                list2 = Nil$.MODULE$.$colon$colon(inetSocketAddress);
            }
        } else {
            if (!((Object)((Object)ConfigValueType.LIST)).equals((Object)configValueType)) throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
            IndexedSeq userAddresses = ((IterableLike)package$JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("nameservers")).asScala()).iterator().map((Function1<String, InetSocketAddress> & Serializable & scala.Serializable)str -> DnsSettings$.MODULE$.parseNameserverAddress((String)str)).to(package$.MODULE$.genericCompanionToCBF(IndexedSeq$.MODULE$));
            Predef$.MODULE$.require(userAddresses.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "nameservers can not be empty");
            list2 = userAddresses.toList();
        }
        this.NameServers = list2;
        Duration duration = JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout"));
        if (JavaDurationConverters$JavaDurationOps$.MODULE$ == null) {
            throw null;
        }
        this.ResolveTimeout = Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos());
        this.PositiveCachePolicy = this.getTtl("positive-ttl");
        this.NegativeCachePolicy = this.getTtl("negative-ttl");
        ConfigValueType configValueType2 = c.getValue("search-domains").valueType();
        if (((Object)((Object)ConfigValueType.STRING)).equals((Object)configValueType2)) {
            String string = c.getString("search-domains");
            list = "default".equals(string) ? (List)this.resolvConf().map((Function1<ResolvConf, List> & Serializable & scala.Serializable)x$3 -> x$3.search()).getOrElse((Function0<Nil$> & Serializable & scala.Serializable)() -> Nil$.MODULE$) : new $colon$colon<Nothing$>((Nothing$)((Object)string), Nil$.MODULE$);
        } else {
            if (!((Object)((Object)ConfigValueType.LIST)).equals((Object)configValueType2)) throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
            list = ((TraversableOnce)package$JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("search-domains")).asScala()).toList();
        }
        this.SearchDomains = list;
        ConfigValueType configValueType3 = c.getValue("ndots").valueType();
        if (((Object)((Object)ConfigValueType.STRING)).equals((Object)configValueType3)) {
            String string = c.getString("ndots");
            if (!"default".equals(string)) throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            n = BoxesRunTime.unboxToInt(this.resolvConf().map((Function1<ResolvConf, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.ndots())).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 1));
        } else {
            if (!((Object)((Object)ConfigValueType.NUMBER)).equals((Object)configValueType3)) throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            int ndots = c.getInt("ndots");
            if (ndots < 0) {
                throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
            }
            n = ndots;
        }
        this.NDots = n;
    }

    public static final /* synthetic */ Object $anonfun$getTtl$1$adapted(Duration x$2) {
        return BoxesRunTime.boxToBoolean(DnsSettings.$anonfun$getTtl$1(x$2));
    }
}

