/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import org.apache.pekko.actor.CoordinatedShutdown$ClusterDowningReason$;
import org.apache.pekko.actor.CoordinatedShutdown$ClusterJoinUnsuccessfulReason$;
import org.apache.pekko.actor.CoordinatedShutdown$ClusterLeavingReason$;
import org.apache.pekko.actor.CoordinatedShutdown$IncompatibleConfigurationDetectedReason$;
import org.apache.pekko.actor.CoordinatedShutdown$JvmExitReason$;
import org.apache.pekko.actor.CoordinatedShutdown$UnknownReason$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.actor.JVMShutdownHooks;
import org.apache.pekko.actor.JVMShutdownHooks$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class CoordinatedShutdown$
implements ExtensionId<CoordinatedShutdown>,
ExtensionIdProvider {
    public static CoordinatedShutdown$ MODULE$;
    private final String PhaseBeforeServiceUnbind;
    private final String PhaseServiceUnbind;
    private final String PhaseServiceRequestsDone;
    private final String PhaseServiceStop;
    private final String PhaseBeforeClusterShutdown;
    private final String PhaseClusterShardingShutdownRegion;
    private final String PhaseClusterLeave;
    private final String PhaseClusterExiting;
    private final String PhaseClusterExitingDone;
    private final String PhaseClusterShutdown;
    private final String PhaseBeforeActorSystemTerminate;
    private final String PhaseActorSystemTerminate;
    private volatile boolean org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook;

    static {
        new CoordinatedShutdown$();
    }

    @Override
    public Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)this, system);
    }

    @Override
    public Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)this, system);
    }

    @Override
    public final int hashCode() {
        return ExtensionId.hashCode$(this);
    }

    @Override
    public final boolean equals(Object other) {
        return ExtensionId.equals$(this, other);
    }

    public JVMShutdownHooks $lessinit$greater$default$3() {
        return JVMShutdownHooks$.MODULE$;
    }

    public String PhaseBeforeServiceUnbind() {
        return this.PhaseBeforeServiceUnbind;
    }

    public String PhaseServiceUnbind() {
        return this.PhaseServiceUnbind;
    }

    public String PhaseServiceRequestsDone() {
        return this.PhaseServiceRequestsDone;
    }

    public String PhaseServiceStop() {
        return this.PhaseServiceStop;
    }

    public String PhaseBeforeClusterShutdown() {
        return this.PhaseBeforeClusterShutdown;
    }

    public String PhaseClusterShardingShutdownRegion() {
        return this.PhaseClusterShardingShutdownRegion;
    }

    public String PhaseClusterLeave() {
        return this.PhaseClusterLeave;
    }

    public String PhaseClusterExiting() {
        return this.PhaseClusterExiting;
    }

    public String PhaseClusterExitingDone() {
        return this.PhaseClusterExitingDone;
    }

    public String PhaseClusterShutdown() {
        return this.PhaseClusterShutdown;
    }

    public String PhaseBeforeActorSystemTerminate() {
        return this.PhaseBeforeActorSystemTerminate;
    }

    public String PhaseActorSystemTerminate() {
        return this.PhaseActorSystemTerminate;
    }

    public CoordinatedShutdown.Reason unknownReason() {
        return CoordinatedShutdown$UnknownReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason actorSystemTerminateReason() {
        return CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason jvmExitReason() {
        return CoordinatedShutdown$JvmExitReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterDowningReason() {
        return CoordinatedShutdown$ClusterDowningReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterJoinUnsuccessfulReason() {
        return CoordinatedShutdown$ClusterJoinUnsuccessfulReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason incompatibleConfigurationDetectedReason() {
        return CoordinatedShutdown$IncompatibleConfigurationDetectedReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterLeavingReason() {
        return CoordinatedShutdown$ClusterLeavingReason$.MODULE$;
    }

    public boolean org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook() {
        return this.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook;
    }

    private void org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook_$eq(boolean x$1) {
        this.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook = x$1;
    }

    @Override
    public CoordinatedShutdown get(ActorSystem system) {
        return (CoordinatedShutdown)ExtensionId.get$((ExtensionId)this, system);
    }

    @Override
    public CoordinatedShutdown get(ClassicActorSystemProvider system) {
        return (CoordinatedShutdown)ExtensionId.get$((ExtensionId)this, system);
    }

    public CoordinatedShutdown$ lookup() {
        return this;
    }

    @Override
    public CoordinatedShutdown createExtension(ExtendedActorSystem system) {
        Config conf = system.settings().config().getConfig("pekko.coordinated-shutdown");
        scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases = this.phasesFromConfig(conf);
        CoordinatedShutdown coord = new CoordinatedShutdown(system, phases, this.$lessinit$greater$default$3());
        this.init(system, conf, coord);
        return coord;
    }

    @InternalApi
    public Config confWithOverrides(Config conf, Option<CoordinatedShutdown.Reason> reason) {
        return (Config)reason.flatMap((Function1<CoordinatedShutdown.Reason, Option> & Serializable & scala.Serializable)r -> {
            String basePath = new StringBuilder(19).append("reason-overrides.\"").append(r.getClass().getName()).append("\"").toString();
            if (conf.hasPath(basePath)) {
                return new Some<Config>(conf.getConfig(basePath).withFallback(conf));
            }
            return None$.MODULE$;
        }).getOrElse((Function0<Config> & Serializable & scala.Serializable)() -> conf);
    }

    @InternalApi
    public void init(ExtendedActorSystem system, Config conf, CoordinatedShutdown coord) {
        this.initPhaseActorSystemTerminate(system, conf, coord);
        this.initJvmHook(system, conf, coord);
        try {
            system.registerOnTermination((JFunction0$mcV$sp & scala.Serializable)() -> this.cleanupActorSystemJvmHook$1(coord));
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.cleanupActorSystemJvmHook$1(coord);
            return;
        }
    }

    private void initPhaseActorSystemTerminate(ExtendedActorSystem system, Config conf, CoordinatedShutdown coord) {
        coord.addTask(this.PhaseActorSystemTerminate(), "terminate-system", (Function0<Future<Done>>)(Function0<Future> & Serializable & scala.Serializable)() -> {
            Config confForReason = MODULE$.confWithOverrides(conf, coord.shutdownReason());
            boolean terminateActorSystem = confForReason.getBoolean("terminate-actor-system");
            boolean exitJvm = confForReason.getBoolean("exit-jvm");
            int exitCode = confForReason.getInt("exit-code");
            if (exitJvm && terminateActorSystem) {
                FiniteDuration timeout = coord.timeout(MODULE$.PhaseActorSystemTerminate());
                Thread t = new Thread(system, timeout, exitCode){
                    private final ExtendedActorSystem system$1;
                    private final FiniteDuration timeout$1;
                    private final int exitCode$1;

                    public void run() {
                        if (Try$.MODULE$.apply((Function0<Future> & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready($this.system$1.whenTerminated(), $this.timeout$1)).isFailure() && !CoordinatedShutdown$.MODULE$.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook()) {
                            System.exit(this.exitCode$1);
                            return;
                        }
                    }
                    {
                        this.system$1 = system$1;
                        this.timeout$1 = timeout$1;
                        this.exitCode$1 = exitCode$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.pekko.actor.CoordinatedShutdown$$anon$1 )}, serializedLambda);
                    }
                };
                t.setName("CoordinatedShutdown-exit");
                t.start();
            }
            if (terminateActorSystem) {
                system.finalTerminate();
                return system.whenTerminated().map((Function1<Terminated, Done$> & Serializable & scala.Serializable)x$1 -> {
                    if (exitJvm && !MODULE$.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook()) {
                        System.exit(exitCode);
                    }
                    return Done$.MODULE$;
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            if (exitJvm) {
                System.exit(exitCode);
                return Future$.MODULE$.successful(Done$.MODULE$);
            }
            return Future$.MODULE$.successful(Done$.MODULE$);
        });
    }

    private void initJvmHook(ActorSystem system, Config conf, CoordinatedShutdown coord) {
        if (system.settings().JvmShutdownHooks() && conf.getBoolean("run-by-jvm-shutdown-hook")) {
            coord.org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(OptionVal$Some$.MODULE$.apply(coord.addCancellableJvmShutdownHook((Function0<Object> & Serializable & scala.Serializable)() -> {
                MODULE$.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook_$eq(true);
                if (!system.whenTerminated().isCompleted()) {
                    coord.log().debug("Starting coordinated shutdown from JVM shutdown hook");
                    try {
                        FiniteDuration totalTimeout = coord.totalTimeout().max(new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds());
                        return Await$.MODULE$.ready(coord.run(CoordinatedShutdown$JvmExitReason$.MODULE$), totalTimeout);
                    }
                    catch (Throwable throwable) {
                        Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                        if (!option.isEmpty()) {
                            Throwable e = option.get();
                            coord.log().warning("CoordinatedShutdown from JVM shutdown failed: {}", (Object)e.getMessage());
                            return BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                }
                return BoxedUnit.UNIT;
            })));
            return;
        }
    }

    public scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phasesFromConfig(Config conf) {
        String defaultPhaseTimeout = conf.getString("default-phase-timeout");
        Config phasesConf = conf.getConfig("phases");
        Config defaultPhaseConfig = ConfigFactory.parseString(new StringBuilder(86).append("\n      timeout = ").append(defaultPhaseTimeout).append("\n      recover = true\n      enabled = true\n      depends-on = []\n    ").toString());
        return ((TraversableOnce)package$JavaConverters$.MODULE$.mapAsScalaMapConverter(phasesConf.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                if (x0$1._2() instanceof Map) {
                    Config c = phasesConf.getConfig(k).withFallback(defaultPhaseConfig);
                    Set<String> dependsOn = ((TraversableOnce)package$JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("depends-on")).asScala()).toSet();
                    FiniteDuration timeout = new package.DurationLong(package$.MODULE$.DurationLong(c.getDuration("timeout", TimeUnit.MILLISECONDS))).millis();
                    boolean recover2 = c.getBoolean("recover");
                    boolean enabled = c.getBoolean("enabled");
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), new CoordinatedShutdown.Phase(dependsOn, timeout, recover2, enabled));
                }
            }
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                Object v = x0$1._2();
                throw new IllegalArgumentException(new StringBuilder(36).append("Expected object value for [").append(k).append("], got [").append(v).append("]").toString());
            }
            throw new MatchError((Object)null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public List<String> topologicalSort(scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases) {
        ObjectRef<GenTraversable> result = ObjectRef.create(List$.MODULE$.empty());
        ObjectRef<Set> unmarked = ObjectRef.create((Set)phases.keySet().$plus$plus(phases.values().flatMap((Function1<CoordinatedShutdown.Phase, Set> & Serializable & scala.Serializable)x$2 -> x$2.dependsOn(), Iterable$.MODULE$.canBuildFrom())));
        ObjectRef<GenTraversable> tempMark = ObjectRef.create(Predef$.MODULE$.Set().empty());
        while (((Set)unmarked.elem).nonEmpty()) {
            CoordinatedShutdown$.depthFirstSearch$1((String)((Set)unmarked.elem).head(), tempMark, phases, unmarked, result);
        }
        return ((List)result.elem).reverse();
    }

    private final void cleanupActorSystemJvmHook$1(CoordinatedShutdown coord$1) {
        Cancellable cancellable = coord$1.org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook();
        Cancellable cancellable2 = OptionVal$Some$.MODULE$.unapply(cancellable);
        if (!OptionVal$.MODULE$.isEmpty$extension(cancellable2)) {
            Cancellable cancellable3 = OptionVal$.MODULE$.get$extension(cancellable2);
            if (!this.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook() && !cancellable3.isCancelled()) {
                cancellable3.cancel();
                OptionVal$.MODULE$.None();
                coord$1.org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(null);
                return;
            }
        }
    }

    private static final void depthFirstSearch$1(String u2, ObjectRef tempMark$1, scala.collection.immutable.Map phases$1, ObjectRef unmarked$1, ObjectRef result$1) {
        if (((Set)tempMark$1.elem).apply(u2)) {
            throw new IllegalArgumentException(new StringBuilder(112).append("Cycle detected in graph of phases. It must be a DAG. ").append("phase [").append(u2).append("] depends transitively on itself. All dependencies: ").append(phases$1).toString());
        }
        if (((Set)unmarked$1.elem).apply(u2)) {
            tempMark$1.elem = (Set)((Set)tempMark$1.elem).$plus(u2);
            Option option = phases$1.get(u2);
            if (option instanceof Some) {
                ((CoordinatedShutdown.Phase)((Some)option).value()).dependsOn().foreach((Function1<String, Object> & Serializable & scala.Serializable)u -> {
                    CoordinatedShutdown$.depthFirstSearch$1(u, tempMark$1, phases$1, unmarked$1, result$1);
                    return BoxedUnit.UNIT;
                });
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
            unmarked$1.elem = (Set)((Set)unmarked$1.elem).$minus(u2);
            tempMark$1.elem = (Set)((Set)tempMark$1.elem).$minus(u2);
            result$1.elem = ((List)result$1.elem).$colon$colon(u2);
            return;
        }
    }

    private CoordinatedShutdown$() {
        MODULE$ = this;
        ExtensionId.$init$(this);
        this.PhaseBeforeServiceUnbind = "before-service-unbind";
        this.PhaseServiceUnbind = "service-unbind";
        this.PhaseServiceRequestsDone = "service-requests-done";
        this.PhaseServiceStop = "service-stop";
        this.PhaseBeforeClusterShutdown = "before-cluster-shutdown";
        this.PhaseClusterShardingShutdownRegion = "cluster-sharding-shutdown-region";
        this.PhaseClusterLeave = "cluster-leave";
        this.PhaseClusterExiting = "cluster-exiting";
        this.PhaseClusterExitingDone = "cluster-exiting-done";
        this.PhaseClusterShutdown = "cluster-shutdown";
        this.PhaseBeforeActorSystemTerminate = "before-actor-system-terminate";
        this.PhaseActorSystemTerminate = "actor-system-terminate";
        this.org$apache$pekko$actor$CoordinatedShutdown$$runningJvmHook = false;
    }
}

