/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import org.apache.flink.runtime.rpc.exceptions.RecipientUnreachableException;
import org.apache.flink.runtime.rpc.messages.Message;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.DeadLetter;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Status;
import org.apache.pekko.japi.pf.ReceiveBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLettersActor
extends AbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(DeadLettersActor.class);

    @Override
    public AbstractActor.Receive createReceive() {
        return new ReceiveBuilder().match(DeadLetter.class, this::handleDeadLetter).build();
    }

    private void handleDeadLetter(DeadLetter deadLetter) {
        if (deadLetter.message() instanceof Message) {
            if (deadLetter.sender().equals(this.getContext().getSystem().deadLetters())) {
                LOG.debug("Could not deliver message {} with no sender to recipient {}. This indicates that the actor terminated unexpectedly.", deadLetter.message(), (Object)deadLetter.recipient());
            } else {
                deadLetter.sender().tell(new Status.Failure((Throwable)new RecipientUnreachableException(deadLetter.sender().toString(), deadLetter.recipient().toString(), deadLetter.message().toString())), this.getSelf());
            }
        }
    }

    public static Props getProps() {
        return Props.create(DeadLettersActor.class, new Object[0]);
    }
}

