/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import com.typesafe.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.transport.netty.ConfigSSLEngineProvider;

public class CustomSSLEngineProvider
extends ConfigSSLEngineProvider {
    private final String sslTrustStore;
    private final String sslTrustStorePassword;
    private final List<String> sslCertFingerprints;
    private final String sslKeyStoreType;
    private final String sslTrustStoreType;

    public CustomSSLEngineProvider(ActorSystem system) {
        super(system);
        Config securityConfig = system.settings().config().getConfig("pekko.remote.classic.netty.ssl.security");
        this.sslTrustStore = securityConfig.getString("trust-store");
        this.sslTrustStorePassword = securityConfig.getString("trust-store-password");
        this.sslCertFingerprints = securityConfig.getStringList("cert-fingerprints");
        this.sslKeyStoreType = securityConfig.getString("key-store-type");
        this.sslTrustStoreType = securityConfig.getString("trust-store-type");
    }

    @Override
    public TrustManager[] trustManagers() {
        try {
            TrustManagerFactory trustManagerFactory = this.sslCertFingerprints.isEmpty() ? TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()) : FingerprintTrustManagerFactory.builder((String)"SHA1").fingerprints(this.sslCertFingerprints).build();
            trustManagerFactory.init(this.loadKeystore(this.sslTrustStore, this.sslTrustStorePassword, this.sslTrustStoreType));
            return trustManagerFactory.getTrustManagers();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
    }

    @Override
    public KeyStore loadKeystore(String filename, String password) {
        try {
            return this.loadKeystore(filename, password, this.sslKeyStoreType);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
    }

    private KeyStore loadKeystore(String filename, String password, String keystoreType) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        try (InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            char[] passwordCharArray = password.toCharArray();
            keyStore.load(fin, passwordCharArray);
        }
        return keyStore;
    }
}

