/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class PbCodegenRowDeserializer
implements PbCodegenDeserializer {
    private final Descriptors.Descriptor descriptor;
    private final RowType rowType;
    private final PbFormatContext formatContext;

    public PbCodegenRowDeserializer(Descriptors.Descriptor descriptor, RowType rowType, PbFormatContext formatContext) {
        this.rowType = rowType;
        this.descriptor = descriptor;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String pbObjectCode, int indent) throws PbCodegenException {
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        String pbMessageVar = "message" + uid;
        String flinkRowDataVar = "rowData" + uid;
        int fieldSize = this.rowType.getFieldNames().size();
        String pbMessageTypeStr = PbFormatUtils.getFullJavaName(this.descriptor);
        appender.appendLine(pbMessageTypeStr + " " + pbMessageVar + " = " + pbObjectCode);
        appender.appendLine("GenericRowData " + flinkRowDataVar + " = new GenericRowData(" + fieldSize + ")");
        int index = 0;
        PbCodegenAppender splitAppender = new PbCodegenAppender(indent);
        for (String fieldName : this.rowType.getFieldNames()) {
            int subUid = varUid.getAndIncrement();
            String flinkRowEleVar = "elementDataVar" + subUid;
            LogicalType subType = this.rowType.getTypeAt(this.rowType.getFieldIndex(fieldName));
            Descriptors.FieldDescriptor elementFd = this.descriptor.findFieldByName(fieldName);
            String strongCamelFieldName = PbFormatUtils.getStrongCamelCaseJsonName(fieldName);
            PbCodegenDeserializer codegen = PbCodegenDeserializeFactory.getPbCodegenDes(elementFd, subType, this.formatContext);
            splitAppender.appendLine("Object " + flinkRowEleVar + " = null");
            boolean readDefaultValues = this.formatContext.getPbFormatConfig().isReadDefaultValues();
            if (PbFormatUtils.isSimpleType(subType)) {
                readDefaultValues = this.formatContext.getReadDefaultValuesForPrimitiveTypes();
            }
            if (!readDefaultValues) {
                String isMessageElementNonEmptyCode = this.isMessageElementNonEmptyCode(pbMessageVar, strongCamelFieldName, PbFormatUtils.isRepeatedType(subType));
                splitAppender.begin("if(" + isMessageElementNonEmptyCode + "){");
            }
            String pbGetMessageElementCode = this.pbGetMessageElementCode(pbMessageVar, strongCamelFieldName, elementFd, PbFormatUtils.isArrayType(subType));
            String code = codegen.codegen(flinkRowEleVar, pbGetMessageElementCode, splitAppender.currentIndent());
            splitAppender.appendSegment(code);
            if (!readDefaultValues) {
                splitAppender.end("}");
            }
            splitAppender.appendLine(flinkRowDataVar + ".setField(" + index + ", " + flinkRowEleVar + ")");
            if (PbCodegenUtils.needToSplit(splitAppender.code().length())) {
                String splitMethod = this.formatContext.splitDeserializerRowTypeMethod(flinkRowDataVar, pbMessageTypeStr, pbMessageVar, splitAppender.code());
                appender.appendSegment(splitMethod);
                splitAppender = new PbCodegenAppender();
            }
            ++index;
        }
        if (!splitAppender.code().isEmpty()) {
            appender.appendSegment(splitAppender.code());
        }
        appender.appendLine(resultVar + " = " + flinkRowDataVar);
        return appender.code();
    }

    private String pbGetMessageElementCode(String message, String fieldName, Descriptors.FieldDescriptor fd, boolean isList) {
        if (fd.isMapField()) {
            return message + ".get" + fieldName + "Map()";
        }
        if (isList) {
            return message + ".get" + fieldName + "List()";
        }
        return message + ".get" + fieldName + "()";
    }

    private String isMessageElementNonEmptyCode(String message, String fieldName, boolean isListOrMap) {
        if (isListOrMap) {
            return message + ".get" + fieldName + "Count() > 0";
        }
        return message + ".has" + fieldName + "()";
    }
}

