/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.vector;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.flink.orc.data.Record;
import org.apache.flink.orc.util.OrcBulkWriterTestUtil;
import org.apache.flink.orc.vector.Vectorizer;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public class RecordVectorizer
extends Vectorizer<Record>
implements Serializable {
    public RecordVectorizer(String schema) {
        super(schema);
    }

    public void vectorize(Record element, VectorizedRowBatch batch) throws IOException {
        BytesColumnVector stringVector = (BytesColumnVector)batch.cols[0];
        LongColumnVector intColVector = (LongColumnVector)batch.cols[1];
        int row = batch.size++;
        stringVector.setVal(row, element.getName().getBytes(StandardCharsets.UTF_8));
        intColVector.vector[row] = element.getAge();
        this.addUserMetadata("userKey", OrcBulkWriterTestUtil.USER_METADATA_VALUE);
    }
}

