/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OrcSplitReaderUtilTest {
    OrcSplitReaderUtilTest() {
    }

    @Test
    void testLogicalTypeToOrcType() {
        this.test("boolean", DataTypes.BOOLEAN());
        this.test("char(123)", DataTypes.CHAR((int)123));
        this.test("varchar(123)", DataTypes.VARCHAR((int)123));
        this.test("string", DataTypes.STRING());
        this.test("binary", DataTypes.BYTES());
        this.test("tinyint", DataTypes.TINYINT());
        this.test("smallint", DataTypes.SMALLINT());
        this.test("int", DataTypes.INT());
        this.test("bigint", DataTypes.BIGINT());
        this.test("float", DataTypes.FLOAT());
        this.test("double", DataTypes.DOUBLE());
        this.test("date", DataTypes.DATE());
        this.test("timestamp", DataTypes.TIMESTAMP());
        this.test("array<float>", DataTypes.ARRAY((DataType)DataTypes.FLOAT()));
        this.test("map<float,bigint>", DataTypes.MAP((DataType)DataTypes.FLOAT(), (DataType)DataTypes.BIGINT()));
        this.test("struct<int0:int,str1:string,double2:double,row3:struct<int0:int,int1:int>>", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"int0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"str1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"double2", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"row3", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"int0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"int1", (DataType)DataTypes.INT())}))}));
        this.test("decimal(4,2)", DataTypes.DECIMAL((int)4, (int)2));
    }

    private void test(String expected, DataType type) {
        Assertions.assertThat((Comparable)OrcSplitReaderUtil.logicalTypeToOrcType((LogicalType)type.getLogicalType())).hasToString(expected);
    }
}

