/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.deser.Deserializers;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.InternalCommonsKt;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.JavaToKotlinDurationConverter;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.KotlinDeserializersKt;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.ReflectionCache;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.RegexDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.SequenceDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.UByteDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.UIntDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.ULongDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.UShortDeserializer;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.ValueClassBoxConverter;
import org.apache.flink.model.openai.com.fasterxml.jackson.module.kotlin.WrapsNullableValueClassBoxDeserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/apache/flink/model/openai/com/fasterxml/jackson/module/kotlin/KotlinDeserializers;", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/deser/Deserializers$Base;", "cache", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/module/kotlin/ReflectionCache;", "useJavaDurationConversion", "", "(Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;Z)V", "findBeanDeserializer", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/JsonDeserializer;", "type", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/JavaType;", "config", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinDeserializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDeserializers.kt\ncom/fasterxml/jackson/module/kotlin/KotlinDeserializers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class KotlinDeserializers
extends Deserializers.Base {
    @NotNull
    private final ReflectionCache cache;
    private final boolean useJavaDurationConversion;

    public KotlinDeserializers(@NotNull ReflectionCache cache2, boolean useJavaDurationConversion) {
        Intrinsics.checkNotNullParameter(cache2, "cache");
        this.cache = cache2;
        this.useJavaDurationConversion = useJavaDurationConversion;
    }

    @Override
    @Nullable
    public JsonDeserializer<?> findBeanDeserializer(@NotNull JavaType type2, @Nullable DeserializationConfig config, @Nullable BeanDescription beanDesc) {
        JsonDeserializer jsonDeserializer;
        Intrinsics.checkNotNullParameter(type2, "type");
        Class<?> rawClass = type2.getRawClass();
        if (type2.isInterface() && Intrinsics.areEqual(rawClass, Sequence.class)) {
            jsonDeserializer = SequenceDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, Regex.class)) {
            jsonDeserializer = RegexDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, UByte.class)) {
            jsonDeserializer = UByteDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, UShort.class)) {
            jsonDeserializer = UShortDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, UInt.class)) {
            jsonDeserializer = UIntDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, ULong.class)) {
            jsonDeserializer = ULongDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, Duration.class)) {
            JavaToKotlinDurationConverter javaToKotlinDurationConverter;
            JavaToKotlinDurationConverter it = javaToKotlinDurationConverter = JavaToKotlinDurationConverter.INSTANCE;
            boolean bl = false;
            JavaToKotlinDurationConverter javaToKotlinDurationConverter2 = this.useJavaDurationConversion ? javaToKotlinDurationConverter : null;
            jsonDeserializer = javaToKotlinDurationConverter2 != null ? javaToKotlinDurationConverter2.getDelegatingDeserializer() : null;
        } else {
            Intrinsics.checkNotNullExpressionValue(rawClass, "rawClass");
            if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
                WrapsNullableValueClassBoxDeserializer wrapsNullableValueClassBoxDeserializer;
                Method method = KotlinDeserializersKt.access$findValueCreator(type2, rawClass);
                if (method != null) {
                    Method it = method;
                    boolean bl = false;
                    Class<?> unboxedClass = it.getReturnType();
                    Intrinsics.checkNotNullExpressionValue(unboxedClass, "unboxedClass");
                    ValueClassBoxConverter<?, ?> converter = this.cache.getValueClassBoxConverter(unboxedClass, JvmClassMappingKt.getKotlinClass(rawClass));
                    wrapsNullableValueClassBoxDeserializer = new WrapsNullableValueClassBoxDeserializer(it, converter);
                } else {
                    wrapsNullableValueClassBoxDeserializer = null;
                }
                jsonDeserializer = wrapsNullableValueClassBoxDeserializer;
            } else {
                jsonDeserializer = null;
            }
        }
        return jsonDeserializer;
    }
}

