/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai.com.fasterxml.jackson.databind.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.type.TypeBindings;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.util.ClassUtil;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_TYPE_LENGTH = 64000;
    protected static final int MAX_TYPE_NESTING = 1000;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory f) {
        this._factory = f;
    }

    public TypeParser withFactory(TypeFactory f) {
        return f == this._factory ? this : new TypeParser(f);
    }

    public JavaType parse(String canonical) throws IllegalArgumentException {
        if (canonical.length() > 64000) {
            throw new IllegalArgumentException(String.format("Failed to parse type %s: too long (%d characters), maximum length allowed: %d", TypeParser._quoteTruncated(canonical), canonical.length(), 64000));
        }
        MyTokenizer tokens2 = new MyTokenizer(canonical.trim());
        JavaType type2 = this.parseType(tokens2, 1000);
        if (tokens2.hasMoreTokens()) {
            throw this._problem(tokens2, "Unexpected tokens after complete type");
        }
        return type2;
    }

    protected JavaType parseType(MyTokenizer tokens2, int nestingAllowed) throws IllegalArgumentException {
        if (!tokens2.hasMoreTokens()) {
            throw this._problem(tokens2, "Unexpected end-of-string");
        }
        Class<?> base = this.findClass(tokens2.nextToken(), tokens2);
        if (tokens2.hasMoreTokens()) {
            String token = tokens2.nextToken();
            if ("<".equals(token)) {
                List<JavaType> parameterTypes = this.parseTypes(tokens2, nestingAllowed - 1);
                TypeBindings b = TypeBindings.create(base, parameterTypes);
                return this._factory._fromClass(null, base, b);
            }
            tokens2.pushBack(token);
        }
        return this._factory._fromClass(null, base, TypeBindings.emptyBindings());
    }

    protected List<JavaType> parseTypes(MyTokenizer tokens2, int nestingAllowed) throws IllegalArgumentException {
        if (nestingAllowed < 0) {
            throw this._problem(tokens2, "too deeply nested; exceeds maximum of 1000 nesting levels");
        }
        ArrayList<JavaType> types = new ArrayList<JavaType>();
        while (tokens2.hasMoreTokens()) {
            types.add(this.parseType(tokens2, nestingAllowed));
            if (!tokens2.hasMoreTokens()) break;
            String token = tokens2.nextToken();
            if (">".equals(token)) {
                return types;
            }
            if (",".equals(token)) continue;
            throw this._problem(tokens2, "Unexpected token '" + token + "', expected ',' or '>')");
        }
        throw this._problem(tokens2, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String className, MyTokenizer tokens2) {
        try {
            return this._factory.findClass(className);
        }
        catch (Exception e) {
            ClassUtil.throwIfRTE(e);
            throw this._problem(tokens2, "Cannot locate class '" + className + "', problem: " + e.getMessage());
        }
    }

    protected IllegalArgumentException _problem(MyTokenizer tokens2, String msg) {
        return new IllegalArgumentException(String.format("Failed to parse type %s (remaining: %s): %s", TypeParser._quoteTruncated(tokens2.getAllInput()), TypeParser._quoteTruncated(tokens2.getRemainingInput()), msg));
    }

    private static String _quoteTruncated(String str) {
        if (str.length() <= 1000) {
            return "'" + str + "'";
        }
        return String.format("'%s...'[truncated %d charaters]", str.substring(0, 1000), str.length() - 1000);
    }

    protected static final class MyTokenizer
    extends StringTokenizer {
        protected final String _input;
        protected int _index;
        protected String _pushbackToken;

        public MyTokenizer(String str) {
            super(str, "<,>", true);
            this._input = str;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pushbackToken != null || super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            String token;
            if (this._pushbackToken != null) {
                token = this._pushbackToken;
                this._pushbackToken = null;
            } else {
                token = super.nextToken();
                this._index += token.length();
                token = token.trim();
            }
            return token;
        }

        public void pushBack(String token) {
            this._pushbackToken = token;
        }

        public String getAllInput() {
            return this._input;
        }

        public String getRemainingInput() {
            return this._input.substring(this._index);
        }
    }
}

