/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.audio.transcriptions;

import com.openai.core.BaseDeserializer;
import com.openai.core.BaseSerializer;
import com.openai.core.JsonValue;
import com.openai.core.Utils;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.audio.transcriptions.Transcription;
import com.openai.models.audio.transcriptions.TranscriptionCreateResponse;
import com.openai.models.audio.transcriptions.TranscriptionVerbose;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"B+\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0005J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u0006\u0010\u001c\u001a\u00020\u0000J\r\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse;", "", "transcription", "Lcom/openai/models/audio/transcriptions/Transcription;", "verbose", "Lcom/openai/models/audio/transcriptions/TranscriptionVerbose;", "_json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/models/audio/transcriptions/Transcription;Lcom/openai/models/audio/transcriptions/TranscriptionVerbose;Lcom/openai/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Visitor;", "(Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Visitor;)Ljava/lang/Object;", "asTranscription", "asVerbose", "equals", "other", "hashCode", "", "isTranscription", "isValid", "isVerbose", "toString", "", "validate", "validity", "validity$openai_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "openai-java-core"})
public final class TranscriptionCreateResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Transcription transcription;
    @Nullable
    private final TranscriptionVerbose verbose;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private TranscriptionCreateResponse(Transcription transcription, TranscriptionVerbose verbose, JsonValue _json) {
        this.transcription = transcription;
        this.verbose = verbose;
        this._json = _json;
    }

    /* synthetic */ TranscriptionCreateResponse(Transcription transcription, TranscriptionVerbose transcriptionVerbose, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            transcription = null;
        }
        if ((n & 2) != 0) {
            transcriptionVerbose = null;
        }
        if ((n & 4) != 0) {
            jsonValue = null;
        }
        this(transcription, transcriptionVerbose, jsonValue);
    }

    @NotNull
    public final Optional<Transcription> transcription() {
        Optional<Transcription> optional = Optional.ofNullable(this.transcription);
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(transcription)");
        return optional;
    }

    @NotNull
    public final Optional<TranscriptionVerbose> verbose() {
        Optional<TranscriptionVerbose> optional = Optional.ofNullable(this.verbose);
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(verbose)");
        return optional;
    }

    public final boolean isTranscription() {
        return this.transcription != null;
    }

    public final boolean isVerbose() {
        return this.verbose != null;
    }

    @NotNull
    public final Transcription asTranscription() {
        return (Transcription)Utils.getOrThrow(this.transcription, "transcription");
    }

    @NotNull
    public final TranscriptionVerbose asVerbose() {
        return (TranscriptionVerbose)Utils.getOrThrow(this.verbose, "verbose");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(_json)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return this.transcription != null ? visitor2.visitTranscription(this.transcription) : (this.verbose != null ? visitor2.visitVerbose(this.verbose) : visitor2.unknown(this._json));
    }

    @NotNull
    public final TranscriptionCreateResponse validate() {
        TranscriptionCreateResponse transcriptionCreateResponse;
        TranscriptionCreateResponse $this$validate_u24lambda_u240 = transcriptionCreateResponse = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitTranscription(@NotNull Transcription transcription) {
                    Intrinsics.checkNotNullParameter(transcription, "transcription");
                    transcription.validate();
                }

                public void visitVerbose(@NotNull TranscriptionVerbose verbose) {
                    Intrinsics.checkNotNullParameter(verbose, "verbose");
                    verbose.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return transcriptionCreateResponse;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (OpenAIInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$openai_java_core() {
        return ((Number)this.accept((Visitor)new Visitor<Integer>(){

            @NotNull
            public Integer visitTranscription(@NotNull Transcription transcription) {
                Intrinsics.checkNotNullParameter(transcription, "transcription");
                return transcription.validity$openai_java_core();
            }

            @NotNull
            public Integer visitVerbose(@NotNull TranscriptionVerbose verbose) {
                Intrinsics.checkNotNullParameter(verbose, "verbose");
                return verbose.validity$openai_java_core();
            }

            @NotNull
            public Integer unknown(@Nullable JsonValue json2) {
                return 0;
            }
        })).intValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptionCreateResponse && Intrinsics.areEqual(this.transcription, ((TranscriptionCreateResponse)other).transcription) && Intrinsics.areEqual(this.verbose, ((TranscriptionCreateResponse)other).verbose);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.transcription, this.verbose};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.transcription != null) {
            string = "TranscriptionCreateResponse{transcription=" + this.transcription + '}';
        } else if (this.verbose != null) {
            string = "TranscriptionCreateResponse{verbose=" + this.verbose + '}';
        } else if (this._json != null) {
            string = "TranscriptionCreateResponse{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid TranscriptionCreateResponse");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final TranscriptionCreateResponse ofTranscription(@NotNull Transcription transcription) {
        return Companion.ofTranscription(transcription);
    }

    @JvmStatic
    @NotNull
    public static final TranscriptionCreateResponse ofVerbose(@NotNull TranscriptionVerbose verbose) {
        return Companion.ofVerbose(verbose);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Companion;", "", "()V", "ofTranscription", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse;", "transcription", "Lcom/openai/models/audio/transcriptions/Transcription;", "ofVerbose", "verbose", "Lcom/openai/models/audio/transcriptions/TranscriptionVerbose;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TranscriptionCreateResponse ofTranscription(@NotNull Transcription transcription) {
            Intrinsics.checkNotNullParameter(transcription, "transcription");
            return new TranscriptionCreateResponse(transcription, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final TranscriptionCreateResponse ofVerbose(@NotNull TranscriptionVerbose verbose) {
            Intrinsics.checkNotNullParameter(verbose, "verbose");
            return new TranscriptionCreateResponse(null, verbose, null, 5, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Deserializer;", "Lcom/openai/core/BaseDeserializer;", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse;", "()V", "deserialize", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/core/ObjectCodec;", "node", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/JsonNode;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nTranscriptionCreateResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranscriptionCreateResponse.kt\ncom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n43#2:221\n43#2:222\n288#3,2:223\n*S KotlinDebug\n*F\n+ 1 TranscriptionCreateResponse.kt\ncom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Deserializer\n*L\n181#1:221\n184#1:222\n198#1:223,2\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<TranscriptionCreateResponse> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(TranscriptionCreateResponse.class));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected TranscriptionCreateResponse deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            Object v9;
            TranscriptionCreateResponse transcriptionCreateResponse;
            List bestMatches2;
            block9: {
                TranscriptionCreateResponse transcriptionCreateResponse2;
                TranscriptionCreateResponse transcriptionCreateResponse3;
                TranscriptionCreateResponse transcriptionCreateResponse4;
                TranscriptionVerbose it;
                TranscriptionCreateResponse[] transcriptionCreateResponseArray;
                int n;
                int $i$f$jacksonTypeRef;
                TranscriptionCreateResponse[] transcriptionCreateResponseArray2;
                Intrinsics.checkNotNullParameter($this$deserialize, "<this>");
                Intrinsics.checkNotNullParameter(node, "node");
                JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
                TranscriptionCreateResponse[] transcriptionCreateResponseArray3 = transcriptionCreateResponseArray2 = new TranscriptionCreateResponse[2];
                int n2 = $i$f$jacksonTypeRef = 0;
                Transcription transcription = (Transcription)this.tryDeserialize($this$deserialize, node, new TypeReference<Transcription>(){});
                if (transcription != null) {
                    Transcription transcription2 = transcription;
                    n = n2;
                    transcriptionCreateResponseArray = transcriptionCreateResponseArray3;
                    boolean bl = false;
                    transcriptionCreateResponse4 = new TranscriptionCreateResponse((Transcription)((Object)it), null, json2, 2, null);
                    transcriptionCreateResponseArray3 = transcriptionCreateResponseArray;
                    n2 = n;
                    transcriptionCreateResponse3 = transcriptionCreateResponse4;
                } else {
                    transcriptionCreateResponse3 = null;
                }
                transcriptionCreateResponseArray3[n2] = transcriptionCreateResponse3;
                TranscriptionCreateResponse[] transcriptionCreateResponseArray4 = transcriptionCreateResponseArray2;
                int n3 = 1;
                $i$f$jacksonTypeRef = 0;
                TranscriptionVerbose transcriptionVerbose = (TranscriptionVerbose)this.tryDeserialize($this$deserialize, node, new TypeReference<TranscriptionVerbose>(){});
                if (transcriptionVerbose != null) {
                    it = transcriptionVerbose;
                    n = n3;
                    transcriptionCreateResponseArray = transcriptionCreateResponseArray4;
                    boolean bl = false;
                    transcriptionCreateResponse4 = new TranscriptionCreateResponse(null, it, json2, 1, null);
                    transcriptionCreateResponseArray4 = transcriptionCreateResponseArray;
                    n3 = n;
                    transcriptionCreateResponse2 = transcriptionCreateResponse4;
                } else {
                    transcriptionCreateResponse2 = null;
                }
                transcriptionCreateResponseArray4[n3] = transcriptionCreateResponse2;
                bestMatches2 = CollectionsKt.toList(Utils.allMaxBy(SequencesKt.filterNotNull(SequencesKt.sequenceOf(transcriptionCreateResponseArray2)), deserialize.bestMatches.3.INSTANCE));
                switch (bestMatches2.size()) {
                    case 0: {
                        transcriptionCreateResponse = new TranscriptionCreateResponse(null, null, json2, 3, null);
                        return transcriptionCreateResponse;
                    }
                    case 1: {
                        transcriptionCreateResponse = (TranscriptionCreateResponse)CollectionsKt.single(bestMatches2);
                        return transcriptionCreateResponse;
                    }
                }
                Iterable $this$firstOrNull$iv = bestMatches2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TranscriptionCreateResponse it2 = (TranscriptionCreateResponse)element$iv;
                    boolean bl = false;
                    if (!it2.isValid()) continue;
                    v9 = element$iv;
                    break block9;
                }
                v9 = null;
            }
            TranscriptionCreateResponse transcriptionCreateResponse5 = v9;
            transcriptionCreateResponse = transcriptionCreateResponse5;
            if (transcriptionCreateResponse5 != null) return transcriptionCreateResponse;
            transcriptionCreateResponse = (TranscriptionCreateResponse)CollectionsKt.first(bestMatches2);
            return transcriptionCreateResponse;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Serializer;", "Lcom/openai/core/BaseSerializer;", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse;", "()V", "serialize", "", "value", "generator", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/core/JsonGenerator;", "provider", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/SerializerProvider;", "openai-java-core"})
    public static final class Serializer
    extends BaseSerializer<TranscriptionCreateResponse> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(TranscriptionCreateResponse.class));
        }

        @Override
        public void serialize(@NotNull TranscriptionCreateResponse value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            if (value.transcription != null) {
                generator.writeObject(value.transcription);
            } else if (value.verbose != null) {
                generator.writeObject(value.verbose);
            } else if (value._json != null) {
                generator.writeObject(value._json);
            } else {
                throw new IllegalStateException("Invalid TranscriptionCreateResponse");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateResponse$Visitor;", "T", "", "unknown", "json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/core/JsonValue;)Ljava/lang/Object;", "visitTranscription", "transcription", "Lcom/openai/models/audio/transcriptions/Transcription;", "(Lcom/openai/models/audio/transcriptions/Transcription;)Ljava/lang/Object;", "visitVerbose", "verbose", "Lcom/openai/models/audio/transcriptions/TranscriptionVerbose;", "(Lcom/openai/models/audio/transcriptions/TranscriptionVerbose;)Ljava/lang/Object;", "openai-java-core"})
    public static interface Visitor<T> {
        public T visitTranscription(@NotNull Transcription var1);

        public T visitVerbose(@NotNull TranscriptionVerbose var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OpenAIInvalidDataException("Unknown TranscriptionCreateResponse: " + json2, null, 2, null);
        }
    }
}

