/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;

class HadoopUtilsTest {
    HadoopUtilsTest() {
    }

    @BeforeAll
    static void setPropertiesToEnableKerberosConfigInit() throws KrbException {
        System.setProperty("java.security.krb5.realm", "EXAMPLE.COM");
        System.setProperty("java.security.krb5.kdc", "kdc");
        System.setProperty("java.security.krb5.conf", "/dev/null");
        Config.refresh();
    }

    @AfterAll
    static void cleanupHadoopConfigs() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    void testShouldReturnFalseWhenNoKerberosCredentialsOrDelegationTokens() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userWithoutCredentialsOrTokens = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        Assumptions.assumeThat((boolean)userWithoutCredentialsOrTokens.hasKerberosCredentials()).isFalse();
        boolean isKerberosEnabled = HadoopUtils.isKerberosSecurityEnabled((UserGroupInformation)userWithoutCredentialsOrTokens);
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)userWithoutCredentialsOrTokens, (boolean)true);
        Assertions.assertThat((boolean)isKerberosEnabled).isTrue();
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void testShouldReturnTrueWhenDelegationTokenIsPresent() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userWithoutCredentialsButHavingToken = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        userWithoutCredentialsButHavingToken.addToken(HadoopUtilsTest.getHDFSDelegationToken());
        Assumptions.assumeThat((boolean)userWithoutCredentialsButHavingToken.hasKerberosCredentials()).isFalse();
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)userWithoutCredentialsButHavingToken, (boolean)true);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    void testShouldReturnTrueWhenKerberosCredentialsArePresent() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userWithCredentials = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)userWithCredentials.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
        Mockito.when((Object)userWithCredentials.hasKerberosCredentials()).thenReturn((Object)true);
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)userWithCredentials, (boolean)true);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    void isKerberosSecurityEnabled_NoKerberos_ReturnsFalse() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.PROXY));
        UserGroupInformation userWithAuthMethodOtherThanKerberos = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.PROXY);
        boolean result = HadoopUtils.isKerberosSecurityEnabled((UserGroupInformation)userWithAuthMethodOtherThanKerberos);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    void testShouldReturnTrueIfTicketCacheIsNotUsed() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation user = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        boolean result = HadoopUtils.areKerberosCredentialsValid((UserGroupInformation)user, (boolean)false);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    void testShouldCheckIfTheUserHasHDFSDelegationToken() {
        UserGroupInformation userWithToken = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        userWithToken.addToken(HadoopUtilsTest.getHDFSDelegationToken());
        boolean result = HadoopUtils.hasHDFSDelegationToken((UserGroupInformation)userWithToken);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    void testShouldReturnFalseIfTheUserHasNoHDFSDelegationToken() {
        UserGroupInformation userWithoutToken = HadoopUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        Assumptions.assumeThat((boolean)userWithoutToken.getTokens().isEmpty()).isTrue();
        boolean result = HadoopUtils.hasHDFSDelegationToken((UserGroupInformation)userWithoutToken);
        Assertions.assertThat((boolean)result).isFalse();
    }

    private static Configuration getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        Configuration conf = new Configuration(true);
        conf.set("hadoop.security.authentication", authenticationMethod.name());
        return conf;
    }

    private static UserGroupInformation createTestUser(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        UserGroupInformation user = UserGroupInformation.createRemoteUser((String)"test-user");
        user.setAuthenticationMethod(authenticationMethod);
        return user;
    }

    private static Token<DelegationTokenIdentifier> getHDFSDelegationToken() {
        Token token = new Token();
        token.setKind(HadoopUtils.HDFS_DELEGATION_TOKEN_KIND);
        return token;
    }
}

