/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import org.apache.flink.core.fs.AbstractRecoverableWriterTest;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;

class HadoopRecoverableWriterTest
extends AbstractRecoverableWriterTest {
    @TempDir
    private static java.nio.file.Path tempFolder;
    private static MiniDFSCluster hdfsCluster;
    private static org.apache.flink.core.fs.FileSystem fileSystem;
    private static Path basePath;

    HadoopRecoverableWriterTest() {
    }

    @BeforeAll
    static void testHadoopVersion() {
        Assumptions.assumeThat((boolean)HadoopUtils.isMinHadoopVersion((int)2, (int)6)).isTrue();
    }

    @BeforeAll
    static void verifyOS() {
        Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).isFalse();
    }

    @BeforeAll
    static void createHDFS() throws Exception {
        File baseDir = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf);
        hdfsCluster = builder.build();
        DistributedFileSystem hdfs = hdfsCluster.getFileSystem();
        fileSystem = new HadoopFileSystem((FileSystem)hdfs);
        basePath = new Path(hdfs.getUri() + "/tests");
    }

    @AfterAll
    static void destroyHDFS() throws Exception {
        if (hdfsCluster != null) {
            hdfsCluster.getFileSystem().delete(new org.apache.hadoop.fs.Path(basePath.toUri()), true);
            hdfsCluster.shutdown();
        }
    }

    public Path getBasePath() {
        return basePath;
    }

    public org.apache.flink.core.fs.FileSystem initializeFileSystem() {
        return fileSystem;
    }
}

