/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.hadoopcompatibility.mapred.wrapper;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.flink.hadoopcompatibility.mapred.wrapper.HadoopTupleUnwrappingIterator;
import org.apache.hadoop.io.IntWritable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HadoopTupleUnwrappingIteratorTest {
    HadoopTupleUnwrappingIteratorTest() {
    }

    @Test
    void testValueIterator() {
        HadoopTupleUnwrappingIterator valIt = new HadoopTupleUnwrappingIterator((TypeSerializer)new WritableSerializer(IntWritable.class));
        ArrayList<Tuple2> tList = new ArrayList<Tuple2>();
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(1)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(2)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(3)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(4)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(5)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(6)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(7)));
        tList.add(new Tuple2((Object)new IntWritable(1), (Object)new IntWritable(8)));
        int expectedKey = 1;
        int[] expectedValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        valIt.set(tList.iterator());
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        for (int expectedValue : expectedValues) {
            Assertions.assertThat((boolean)valIt.hasNext()).isTrue();
            Assertions.assertThat((int)((IntWritable)valIt.next()).get()).isEqualTo(expectedValue);
            Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        }
        Assertions.assertThat((boolean)valIt.hasNext()).isFalse();
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        tList.clear();
        tList.add(new Tuple2((Object)new IntWritable(2), (Object)new IntWritable(10)));
        expectedKey = 2;
        expectedValues = new int[]{10};
        valIt.set(tList.iterator());
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        for (int expectedValue : expectedValues) {
            Assertions.assertThat((boolean)valIt.hasNext()).isTrue();
            Assertions.assertThat((int)((IntWritable)valIt.next()).get()).isEqualTo(expectedValue);
            Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        }
        Assertions.assertThat((boolean)valIt.hasNext()).isFalse();
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        tList.clear();
        tList.add(new Tuple2((Object)new IntWritable(3), (Object)new IntWritable(10)));
        tList.add(new Tuple2((Object)new IntWritable(3), (Object)new IntWritable(4)));
        tList.add(new Tuple2((Object)new IntWritable(3), (Object)new IntWritable(7)));
        tList.add(new Tuple2((Object)new IntWritable(3), (Object)new IntWritable(9)));
        tList.add(new Tuple2((Object)new IntWritable(4), (Object)new IntWritable(21)));
        expectedKey = 3;
        expectedValues = new int[]{10, 4, 7, 9, 21};
        valIt.set(tList.iterator());
        Assertions.assertThat((boolean)valIt.hasNext()).isTrue();
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        for (int expectedValue : expectedValues) {
            Assertions.assertThat((boolean)valIt.hasNext()).isTrue();
            Assertions.assertThat((int)((IntWritable)valIt.next()).get()).isEqualTo(expectedValue);
            Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        }
        Assertions.assertThat((boolean)valIt.hasNext()).isFalse();
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        tList.clear();
        tList.add(new Tuple2((Object)new IntWritable(4), (Object)new IntWritable(5)));
        tList.add(new Tuple2((Object)new IntWritable(4), (Object)new IntWritable(8)));
        tList.add(new Tuple2((Object)new IntWritable(4), (Object)new IntWritable(42)));
        tList.add(new Tuple2((Object)new IntWritable(4), (Object)new IntWritable(-1)));
        tList.add(new Tuple2((Object)new IntWritable(4), (Object)new IntWritable(0)));
        expectedKey = 4;
        expectedValues = new int[]{5, 8, 42, -1, 0};
        valIt.set(tList.iterator());
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
        for (int expectedValue : expectedValues) {
            Assertions.assertThat((int)((IntWritable)valIt.next()).get()).isEqualTo(expectedValue);
        }
        Assertions.assertThatThrownBy(() -> valIt.next()).isInstanceOf(NoSuchElementException.class);
        Assertions.assertThat((boolean)valIt.hasNext()).isFalse();
        Assertions.assertThat((int)((IntWritable)valIt.getCurrentKey()).get()).isEqualTo(expectedKey);
    }
}

