/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.IOException;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.FirstAttemptInitializationContext;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.hadoop.mapred.HadoopOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HadoopOutputFormatTest {
    HadoopOutputFormatTest() {
    }

    @Test
    void testOpen() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        JobConf jobConf = (JobConf)Mockito.spy((Object)new JobConf());
        Mockito.when((Object)jobConf.getOutputCommitter()).thenReturn((Object)outputCommitter);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)1, (int)1));
        ((JobConf)Mockito.verify((Object)jobConf, (VerificationMode)Mockito.times((int)2))).getOutputCommitter();
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)1)))).setupJob((JobContext)Mockito.any(JobContext.class));
        ((OutputFormat)Mockito.verify((Object)dummyOutputFormat, (VerificationMode)Mockito.times((int)1))).getRecordWriter((FileSystem)ArgumentMatchers.nullable(FileSystem.class), (JobConf)Mockito.any(JobConf.class), ArgumentMatchers.anyString(), (Progressable)Mockito.any(Progressable.class));
    }

    @Test
    void testConfigureWithConfigurable() {
        ConfigurableDummyOutputFormat dummyOutputFormat = (ConfigurableDummyOutputFormat)Mockito.mock(ConfigurableDummyOutputFormat.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat((OutputFormat)dummyOutputFormat, jobConf);
        outputFormat.configure((Configuration)ArgumentMatchers.any());
        ((ConfigurableDummyOutputFormat)Mockito.verify((Object)dummyOutputFormat, (VerificationMode)Mockito.times((int)1))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(org.apache.hadoop.conf.Configuration.class));
    }

    @Test
    void testConfigureWithJobConfigurable() {
        JobConfigurableDummyOutputFormat dummyOutputFormat = (JobConfigurableDummyOutputFormat)Mockito.mock(JobConfigurableDummyOutputFormat.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat((OutputFormat)dummyOutputFormat, jobConf);
        outputFormat.configure((Configuration)ArgumentMatchers.any());
        ((JobConfigurableDummyOutputFormat)Mockito.verify((Object)dummyOutputFormat, (VerificationMode)Mockito.times((int)1))).configure((JobConf)Mockito.any(JobConf.class));
    }

    @Test
    void testCloseWithTaskCommit() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        Mockito.when((Object)outputCommitter.needsTaskCommit((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class))).thenReturn((Object)true);
        DummyRecordWriter recordWriter = (DummyRecordWriter)Mockito.mock(DummyRecordWriter.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.recordWriter = recordWriter;
        outputFormat.outputCommitter = outputCommitter;
        outputFormat.close();
        ((DummyRecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).close((Reporter)ArgumentMatchers.nullable(Reporter.class));
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)1)))).commitTask((TaskAttemptContext)ArgumentMatchers.nullable(TaskAttemptContext.class));
    }

    @Test
    void testCloseWithoutTaskCommit() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        Mockito.when((Object)outputCommitter.needsTaskCommit((TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenReturn((Object)false);
        DummyRecordWriter recordWriter = (DummyRecordWriter)Mockito.mock(DummyRecordWriter.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.recordWriter = recordWriter;
        outputFormat.outputCommitter = outputCommitter;
        outputFormat.close();
        ((DummyRecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).close((Reporter)Mockito.any(Reporter.class));
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)0)))).commitTask((TaskAttemptContext)Mockito.any(TaskAttemptContext.class));
    }

    @Test
    void testWriteRecord() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyRecordWriter recordWriter = (DummyRecordWriter)Mockito.mock(DummyRecordWriter.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.recordWriter = recordWriter;
        outputFormat.writeRecord(new Tuple2((Object)"key", (Object)1L));
        ((DummyRecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).write(ArgumentMatchers.anyString(), Mockito.anyLong());
    }

    @Test
    void testFinalizeGlobal() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        JobConf jobConf = (JobConf)Mockito.spy((Object)new JobConf());
        Mockito.when((Object)jobConf.getOutputCommitter()).thenReturn((Object)outputCommitter);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.finalizeGlobal(new FinalizeOnMaster.FinalizationContext(){

            public int getParallelism() {
                return 1;
            }

            public int getFinishedAttempt(int subtaskIndex) {
                return 0;
            }
        });
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)1)))).commitJob((JobContext)Mockito.any(JobContext.class));
    }

    private class DummyRecordWriter
    implements RecordWriter<String, Long> {
        private DummyRecordWriter() {
        }

        public void write(String s, Long aLong) throws IOException {
        }

        public void close(Reporter reporter) throws IOException {
        }
    }

    private class DummyOutputCommitter
    extends OutputCommitter {
        private DummyOutputCommitter() {
        }

        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }
    }

    private class JobConfigurableDummyOutputFormat
    extends DummyOutputFormat
    implements JobConfigurable {
        private JobConfigurableDummyOutputFormat() {
        }

        public void configure(JobConf jobConf) {
        }
    }

    private class ConfigurableDummyOutputFormat
    extends DummyOutputFormat
    implements Configurable {
        private ConfigurableDummyOutputFormat() {
        }

        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }
    }

    private class DummyOutputFormat
    implements OutputFormat<String, Long> {
        private DummyOutputFormat() {
        }

        public RecordWriter<String, Long> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
        }
    }
}

