/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.eventtime.functions;

import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.api.common.watermark.WatermarkDeclaration;
import org.apache.flink.api.common.watermark.WatermarkHandlingResult;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.TwoOutputNonPartitionedContext;
import org.apache.flink.datastream.api.context.TwoOutputPartitionedContext;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoOutputEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.timer.EventTimeManager;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.EventTimeExtensionImpl;
import org.apache.flink.datastream.impl.extension.eventtime.timer.DefaultEventTimeManager;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.runtime.watermark.extension.eventtime.EventTimeWatermarkHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class EventTimeWrappedTwoOutputStreamProcessFunction<IN, OUT1, OUT2>
implements TwoOutputStreamProcessFunction<IN, OUT1, OUT2> {
    private final TwoOutputEventTimeStreamProcessFunction<IN, OUT1, OUT2> wrappedUserFunction;
    private transient EventTimeManager eventTimeManager;
    private transient EventTimeWatermarkHandler eventTimeWatermarkHandler;

    public EventTimeWrappedTwoOutputStreamProcessFunction(TwoOutputEventTimeStreamProcessFunction<IN, OUT1, OUT2> wrappedUserFunction) {
        this.wrappedUserFunction = (TwoOutputEventTimeStreamProcessFunction)Preconditions.checkNotNull(wrappedUserFunction);
    }

    public void open(TwoOutputNonPartitionedContext<OUT1, OUT2> ctx) throws Exception {
        this.wrappedUserFunction.initEventTimeProcessFunction(this.eventTimeManager);
        this.wrappedUserFunction.open(ctx);
    }

    public void initEventTimeExtension(@Nullable InternalTimerService<VoidNamespace> timerService, Supplier<Long> eventTimeSupplier, EventTimeWatermarkHandler eventTimeWatermarkHandler) {
        this.eventTimeManager = new DefaultEventTimeManager(timerService, eventTimeSupplier);
        this.eventTimeWatermarkHandler = eventTimeWatermarkHandler;
    }

    public void processRecord(IN record, Collector<OUT1> output1, Collector<OUT2> output2, TwoOutputPartitionedContext<OUT1, OUT2> ctx) throws Exception {
        this.wrappedUserFunction.processRecord(record, output1, output2, ctx);
    }

    public void endInput(TwoOutputNonPartitionedContext<OUT1, OUT2> ctx) throws Exception {
        this.wrappedUserFunction.endInput(ctx);
    }

    public void onProcessingTimer(long timestamp, Collector<OUT1> output1, Collector<OUT2> output2, TwoOutputPartitionedContext<OUT1, OUT2> ctx) throws Exception {
        this.wrappedUserFunction.onProcessingTimer(timestamp, output1, output2, ctx);
    }

    public WatermarkHandlingResult onWatermark(Watermark watermark, Collector<OUT1> output1, Collector<OUT2> output2, TwoOutputNonPartitionedContext<OUT1, OUT2> ctx) throws Exception {
        if (EventTimeExtensionImpl.isEventTimeExtensionWatermark(watermark)) {
            try {
                EventTimeWatermarkHandler.EventTimeUpdateStatus eventTimeUpdateStatus = this.eventTimeWatermarkHandler.processWatermark(watermark, 0);
                if (eventTimeUpdateStatus.isEventTimeUpdated()) {
                    this.wrappedUserFunction.onEventTimeWatermark(eventTimeUpdateStatus.getNewEventTime(), output1, output2, ctx);
                }
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            return WatermarkHandlingResult.POLL;
        }
        return this.wrappedUserFunction.onWatermark(watermark, output1, output2, ctx);
    }

    public void onEventTime(long timestamp, Collector<OUT1> output1, Collector<OUT2> output2, TwoOutputPartitionedContext<OUT1, OUT2> ctx) throws Exception {
        this.wrappedUserFunction.onEventTimer(timestamp, output1, output2, ctx);
    }

    public Set<StateDeclaration> usesStates() {
        return this.wrappedUserFunction.usesStates();
    }

    public Set<? extends WatermarkDeclaration> declareWatermarks() {
        return this.wrappedUserFunction.declareWatermarks();
    }

    public void close() throws Exception {
        this.wrappedUserFunction.close();
    }

    public TwoOutputStreamProcessFunction<IN, OUT1, OUT2> getWrappedUserFunction() {
        return this.wrappedUserFunction;
    }
}

