/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.connector.file.table.EnrichedRowData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnrichedRowDataTest {
    EnrichedRowDataTest() {
    }

    @Test
    void testEnrichedRow() {
        List<String> completeRowFields = Arrays.asList("fixedRow1", "mutableRow1", "mutableRow3", "mutableRow2", "fixedRow2", "mutableRow4");
        List<String> mutableRowFields = Arrays.asList("mutableRow1", "mutableRow2", "mutableRow3", "mutableRow4");
        List<String> fixedRowFields = Arrays.asList("fixedRow1", "fixedRow2");
        GenericRowData fixedRowData = GenericRowData.of((Object[])new Object[]{1L, 2L});
        EnrichedRowData enrichedRowData = EnrichedRowData.from((RowData)fixedRowData, completeRowFields, mutableRowFields, fixedRowFields);
        GenericRowData mutableRowData = GenericRowData.of((Object[])new Object[]{3L, 4L, 5L, 6L});
        enrichedRowData.replaceMutableRow((RowData)mutableRowData);
        Assertions.assertEquals((Object)RowKind.INSERT, (Object)enrichedRowData.getRowKind());
        Assertions.assertEquals((int)6, (int)enrichedRowData.getArity());
        Assertions.assertEquals((long)1L, (long)enrichedRowData.getLong(0));
        Assertions.assertEquals((long)3L, (long)enrichedRowData.getLong(1));
        Assertions.assertEquals((long)5L, (long)enrichedRowData.getLong(2));
        Assertions.assertEquals((long)4L, (long)enrichedRowData.getLong(3));
        Assertions.assertEquals((long)2L, (long)enrichedRowData.getLong(4));
        Assertions.assertEquals((long)6L, (long)enrichedRowData.getLong(5));
        GenericRowData newMutableRowData = GenericRowData.of((Object[])new Object[]{7L, 8L, 9L, 10L});
        enrichedRowData.replaceMutableRow((RowData)newMutableRowData);
        Assertions.assertEquals((long)1L, (long)enrichedRowData.getLong(0));
        Assertions.assertEquals((long)7L, (long)enrichedRowData.getLong(1));
        Assertions.assertEquals((long)9L, (long)enrichedRowData.getLong(2));
        Assertions.assertEquals((long)8L, (long)enrichedRowData.getLong(3));
        Assertions.assertEquals((long)2L, (long)enrichedRowData.getLong(4));
        Assertions.assertEquals((long)10L, (long)enrichedRowData.getLong(5));
    }
}

