/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.ReaderInfo;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.mocks.MockSplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.enumerate.DynamicFileEnumerator;
import org.apache.flink.connector.file.src.impl.DynamicFileSplitEnumerator;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.connector.source.DynamicFilteringData;
import org.apache.flink.table.connector.source.DynamicFilteringEvent;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DynamicFileSplitEnumeratorTest {
    DynamicFileSplitEnumeratorTest() {
    }

    @Test
    void testEnumerating() {
        Object[] splits = new String[]{"0", "1", "2", "3", "4"};
        MockSplitEnumeratorContext context = new MockSplitEnumeratorContext(1);
        context.registerReader(new ReaderInfo(0, ""));
        DynamicFileSplitEnumerator enumerator = new DynamicFileSplitEnumerator((SplitEnumeratorContext)context, () -> DynamicFileSplitEnumeratorTest.lambda$testEnumerating$64d9e2a3$1((String[])splits), SimpleSplitAssigner::new);
        for (String string : splits) {
            enumerator.handleSplitRequest(0, null);
        }
        Assertions.assertThat(DynamicFileSplitEnumeratorTest.getAssignedSplits((MockSplitEnumeratorContext<TestSplit>)context)).containsExactlyInAnyOrder(splits);
    }

    @Test
    void testDynamicFiltering() {
        String[] splits = new String[]{"0", "1", "2", "3", "4"};
        Object[] remainingSplits = new String[]{"1", "3"};
        MockSplitEnumeratorContext context = new MockSplitEnumeratorContext(1);
        context.registerReader(new ReaderInfo(0, ""));
        DynamicFileSplitEnumerator enumerator = new DynamicFileSplitEnumerator((SplitEnumeratorContext)context, () -> DynamicFileSplitEnumeratorTest.lambda$testDynamicFiltering$96ced51b$1(splits, (String[])remainingSplits), SimpleSplitAssigner::new);
        enumerator.handleSourceEvent(0, DynamicFileSplitEnumeratorTest.mockDynamicFilteringEvent());
        enumerator.handleSplitRequest(0, null);
        enumerator.handleSplitRequest(0, null);
        Assertions.assertThat(DynamicFileSplitEnumeratorTest.getAssignedSplits((MockSplitEnumeratorContext<TestSplit>)context)).containsExactlyInAnyOrder(remainingSplits);
    }

    @Test
    void testReceiveDynamicFilteringDataAfterStarted() {
        String[] splits = new String[]{"0", "1", "2", "3", "4"};
        String[] remainingSplits = new String[]{"1", "3"};
        MockSplitEnumeratorContext context = new MockSplitEnumeratorContext(1);
        context.registerReader(new ReaderInfo(0, ""));
        DynamicFileSplitEnumerator enumerator = new DynamicFileSplitEnumerator((SplitEnumeratorContext)context, (DynamicFileEnumerator.Provider & Serializable)() -> new TestDynamicFileEnumerator(splits, remainingSplits), SimpleSplitAssigner::new);
        enumerator.handleSplitRequest(0, null);
        List<String> alreadyAssigned = DynamicFileSplitEnumeratorTest.getAssignedSplits((MockSplitEnumeratorContext<TestSplit>)context);
        enumerator.handleSourceEvent(0, DynamicFileSplitEnumeratorTest.mockDynamicFilteringEvent());
        for (int i = 0; i < 6; ++i) {
            enumerator.handleSplitRequest(0, null);
        }
        alreadyAssigned.addAll(Arrays.asList(remainingSplits));
        Assertions.assertThat(DynamicFileSplitEnumeratorTest.getAssignedSplits((MockSplitEnumeratorContext<TestSplit>)context)).containsExactlyInAnyOrder((Object[])((String[])alreadyAssigned.stream().distinct().toArray(String[]::new)));
    }

    @Test
    void testAddSplitsBack() {
        String[] splits = new String[]{"0", "1", "2", "3", "4"};
        Object[] remainingSplits = new String[]{"1", "3"};
        MockSplitEnumeratorContext context = new MockSplitEnumeratorContext(1);
        context.registerReader(new ReaderInfo(0, ""));
        DynamicFileSplitEnumerator enumerator = new DynamicFileSplitEnumerator((SplitEnumeratorContext)context, () -> DynamicFileSplitEnumeratorTest.lambda$testAddSplitsBack$96ced51b$1(splits, (String[])remainingSplits), SimpleSplitAssigner::new);
        for (String ignored : splits) {
            enumerator.handleSplitRequest(0, null);
        }
        enumerator.handleSourceEvent(0, DynamicFileSplitEnumeratorTest.mockDynamicFilteringEvent());
        enumerator.addSplitsBack(Arrays.stream(splits).map(TestSplit::new).collect(Collectors.toList()), 0);
        for (String ignored : splits) {
            enumerator.handleSplitRequest(0, null);
        }
        List<String> assignedSplits = DynamicFileSplitEnumeratorTest.getAssignedSplits((MockSplitEnumeratorContext<TestSplit>)context);
        Assertions.assertThat(assignedSplits.subList(5, assignedSplits.size())).containsExactlyInAnyOrder(remainingSplits);
    }

    private static SourceEvent mockDynamicFilteringEvent() {
        return new DynamicFilteringEvent(new DynamicFilteringData((TypeInformation)new GenericTypeInfo(RowData.class), RowType.of((LogicalType[])new LogicalType[0]), Collections.emptyList(), false));
    }

    private static List<String> getAssignedSplits(MockSplitEnumeratorContext<TestSplit> context) {
        return context.getSplitsAssignmentSequence().stream().flatMap(s -> ((List)s.assignment().get(0)).stream()).map(FileSourceSplit::splitId).collect(Collectors.toList());
    }

    private static /* synthetic */ DynamicFileEnumerator lambda$testAddSplitsBack$96ced51b$1(String[] splits, String[] remainingSplits) {
        return new TestDynamicFileEnumerator(splits, remainingSplits);
    }

    private static /* synthetic */ DynamicFileEnumerator lambda$testDynamicFiltering$96ced51b$1(String[] splits, String[] remainingSplits) {
        return new TestDynamicFileEnumerator(splits, remainingSplits);
    }

    private static /* synthetic */ DynamicFileEnumerator lambda$testEnumerating$64d9e2a3$1(String[] splits) {
        return new TestDynamicFileEnumerator(splits, splits);
    }

    private static class TestDynamicFileEnumerator
    implements DynamicFileEnumerator {
        private final List<String> remainingSplits;
        private List<String> enumeratingSplits;

        private TestDynamicFileEnumerator(String[] allSplits, String[] remainingSplits) {
            this.remainingSplits = Arrays.asList(remainingSplits);
            this.enumeratingSplits = Arrays.asList(allSplits);
        }

        public void setDynamicFilteringData(DynamicFilteringData data) {
            this.enumeratingSplits = this.remainingSplits;
        }

        public Collection<FileSourceSplit> enumerateSplits(Path[] paths, int minDesiredSplits) {
            return this.enumeratingSplits.stream().map(TestSplit::new).collect(Collectors.toList());
        }
    }

    private static class TestSplit
    extends FileSourceSplit {
        public TestSplit(String id) {
            super(id, new Path(), 0L, 0L, 0L, 0L);
        }
    }
}

