/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumerator;
import org.apache.flink.connector.file.src.testutils.TestingFileSystem;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class NonSplittingRecursiveEnumeratorTest {
    protected TestingFileSystem testFs;

    NonSplittingRecursiveEnumeratorTest() {
    }

    @AfterEach
    void unregisterTestFs() throws Exception {
        if (this.testFs != null) {
            this.testFs.unregister();
        }
    }

    @Test
    void testIncludeFilesFromNestedDirectories() throws Exception {
        Object[] testPaths = new Path[]{new Path("testfs:///dir/file1"), new Path("testfs:///dir/nested/file.out"), new Path("testfs:///dir/nested/anotherfile.txt")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", (Path[])testPaths);
        this.testFs.register();
        NonSplittingRecursiveEnumerator enumerator = this.createEnumerator();
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///dir")}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).containsExactlyInAnyOrder(testPaths);
    }

    @Test
    void testDefaultHiddenFilesFilter() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///visiblefile"), new Path("testfs:///.hiddenfile1"), new Path("testfs:///_hiddenfile2")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        NonSplittingRecursiveEnumerator enumerator = this.createEnumerator();
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///")}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).isEqualTo(Collections.singletonList(new Path("testfs:///visiblefile")));
    }

    @Test
    void testHiddenDirectories() throws Exception {
        Path[] testPaths = new Path[]{new Path("testfs:///dir/visiblefile"), new Path("testfs:///dir/.hiddendir/file"), new Path("testfs:///_notvisible/afile")};
        this.testFs = TestingFileSystem.createWithFiles("testfs", testPaths);
        this.testFs.register();
        NonSplittingRecursiveEnumerator enumerator = this.createEnumerator();
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///")}, 1);
        Assertions.assertThat(NonSplittingRecursiveEnumeratorTest.toPaths(splits)).isEqualTo(Collections.singletonList(new Path("testfs:///dir/visiblefile")));
    }

    @Test
    void testFilesWithNoBlockInfo() throws Exception {
        Path testPath = new Path("testfs:///dir/file1");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 12345L, new BlockLocation[0]));
        this.testFs.register();
        NonSplittingRecursiveEnumerator enumerator = this.createEnumerator();
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///dir")}, 0);
        Assertions.assertThat((Collection)splits).hasSize(1);
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(new FileSourceSplit("ignoredId", testPath, 0L, 12345L, 0L, 12345L), (FileSourceSplit)splits.iterator().next());
    }

    @Test
    void testFileWithIncorrectBlocks() throws Exception {
        Path testPath = new Path("testfs:///testdir/testfile");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 10000L, new TestingFileSystem.TestBlockLocation(0L, 1000L, new String[0]), new TestingFileSystem.TestBlockLocation(2000L, 1000L, new String[0])));
        this.testFs.register();
        NonSplittingRecursiveEnumerator enumerator = this.createEnumerator();
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///testdir")}, 0);
        Assertions.assertThat((Collection)splits).hasSize(1);
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(new FileSourceSplit("ignoredId", testPath, 0L, 10000L, 0L, 12345L), (FileSourceSplit)splits.iterator().next());
    }

    @Test
    void testFileWithMultipleBlocks() throws Exception {
        Path testPath = new Path("testfs:///dir/file");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 1000L, new TestingFileSystem.TestBlockLocation(0L, 100L, "host1", "host2"), new TestingFileSystem.TestBlockLocation(100L, 520L, "host2", "host3"), new TestingFileSystem.TestBlockLocation(620L, 380L, "host3", "host4")));
        this.testFs.register();
        NonSplittingRecursiveEnumerator enumerator = this.createEnumerator();
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///dir")}, 0);
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(new FileSourceSplit("ignoredId", testPath, 0L, 1000L, 0L, 1000L, new String[]{"host1", "host2", "host3", "host4"}), (FileSourceSplit)splits.iterator().next());
    }

    protected NonSplittingRecursiveEnumerator createEnumerator() {
        return new NonSplittingRecursiveEnumerator();
    }

    protected static void assertSplitsEqual(FileSourceSplit expected, FileSourceSplit actual) {
        Assertions.assertThat((Object)actual.path()).isEqualTo((Object)expected.path());
        Assertions.assertThat((long)actual.offset()).isEqualTo(expected.offset());
        Assertions.assertThat((long)actual.length()).isEqualTo(expected.length());
        Assertions.assertThat((Object[])actual.hostnames()).isEqualTo((Object)expected.hostnames());
    }

    protected static void assertSplitsEqual(Collection<FileSourceSplit> expected, Collection<FileSourceSplit> actual) {
        Assertions.assertThat(actual).hasSize(expected.size());
        ArrayList<FileSourceSplit> expectedCopy = new ArrayList<FileSourceSplit>(expected);
        ArrayList<FileSourceSplit> actualCopy = new ArrayList<FileSourceSplit>(expected);
        expectedCopy.sort(NonSplittingRecursiveEnumeratorTest::compareFileSourceSplit);
        actualCopy.sort(NonSplittingRecursiveEnumeratorTest::compareFileSourceSplit);
        for (int i = 0; i < expectedCopy.size(); ++i) {
            NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(expectedCopy.get(i), actualCopy.get(i));
        }
    }

    protected static Collection<Path> toPaths(Collection<FileSourceSplit> splits) {
        return splits.stream().map(FileSourceSplit::path).collect(Collectors.toList());
    }

    private static int compareFileSourceSplit(FileSourceSplit a, FileSourceSplit b) {
        return Long.compare(a.offset(), b.offset());
    }
}

