/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.BlockSplittingRecursiveAllDirEnumerator;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveAllDirEnumeratorTest;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumeratorTest;
import org.apache.flink.connector.file.src.testutils.TestingFileSystem;
import org.apache.flink.core.fs.Path;
import org.junit.jupiter.api.Test;

public class BlockSplittingRecursiveAllDirEnumeratorTest
extends NonSplittingRecursiveAllDirEnumeratorTest {
    @Override
    @Test
    void testFileWithMultipleBlocks() throws Exception {
        Path testPath = new Path("testfs:///dir/file");
        this.testFs = TestingFileSystem.createForFileStatus("testfs", TestingFileSystem.TestFileStatus.forFileWithBlocks(testPath, 1000L, new TestingFileSystem.TestBlockLocation(0L, 100L, "host1", "host2"), new TestingFileSystem.TestBlockLocation(100L, 520L, "host2", "host3"), new TestingFileSystem.TestBlockLocation(620L, 380L, "host3", "host4")));
        this.testFs.register();
        FileEnumerator enumerator = this.createEnumerator(testPath.getPath());
        Collection splits = enumerator.enumerateSplits(new Path[]{new Path("testfs:///dir")}, 0);
        List<FileSourceSplit> expected = Arrays.asList(new FileSourceSplit("ignoredId", testPath, 0L, 100L, 0L, 1000L, new String[]{"host1", "host2"}), new FileSourceSplit("ignoredId", testPath, 100L, 520L, 0L, 1000L, new String[]{"host1", "host2"}), new FileSourceSplit("ignoredId", testPath, 620L, 380L, 0L, 1000L, new String[]{"host1", "host2"}));
        NonSplittingRecursiveEnumeratorTest.assertSplitsEqual(expected, splits);
    }

    @Override
    protected FileEnumerator createEnumerator(String pattern) {
        return new BlockSplittingRecursiveAllDirEnumerator(pattern);
    }
}

