/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.mocks;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.base.source.reader.mocks.MockSplitState;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;

public class MockRecordEmitter
implements RecordEmitter<int[], Integer, MockSplitState> {
    public static final int RECORD_SIZE_IN_BYTES = 10;
    private final SourceReaderMetricGroup metricGroup;
    private final Set<MockSplitState> knownSplits = Collections.newSetFromMap(new IdentityHashMap());

    MockRecordEmitter(SourceReaderMetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.metricGroup.setPendingBytesGauge(() -> this.knownSplits.stream().mapToLong(MockSplitState::getPendingRecords).sum() * 10L);
        this.metricGroup.setPendingRecordsGauge(() -> this.knownSplits.stream().mapToLong(MockSplitState::getPendingRecords).sum());
    }

    public void emitRecord(int[] record, SourceOutput<Integer> output, MockSplitState splitState) {
        this.knownSplits.add(splitState);
        if (record[0] % 2 == 0) {
            this.metricGroup.getNumRecordsInErrorsCounter().inc();
        }
        this.metricGroup.getIOMetricGroup().getNumBytesInCounter().inc(10L);
        this.metricGroup.getIOMetricGroup().getNumBytesOutCounter().inc(10L);
        output.collect((Object)record[0]);
        splitState.setRecordIndex(record[1] + 1);
    }
}

