/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed16;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class EncoderDecoderTest {
    EncoderDecoderTest() {
    }

    @Test
    void testComplexStringsDirectly() {
        try {
            Random rnd = new Random(349712539451944123L);
            for (int i = 0; i < 10; ++i) {
                String testString = StringUtils.getRandomString((Random)rnd, (int)10, (int)100);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                DataOutputStream dataOut = new DataOutputStream(baos);
                DataOutputEncoder encoder = new DataOutputEncoder();
                encoder.setOut((DataOutput)dataOut);
                encoder.writeString(testString);
                dataOut.flush();
                dataOut.close();
                byte[] data = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dataIn = new DataInputStream(bais);
                DataInputDecoder decoder = new DataInputDecoder();
                decoder.setIn((DataInput)dataIn);
                String deserialized = decoder.readString();
                Assertions.assertThat((String)deserialized).isEqualTo(testString);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test failed due to an exception: " + e.getMessage()));
        }
    }

    @Test
    void testPrimitiveTypes() {
        EncoderDecoderTest.testObjectSerialization(Boolean.TRUE);
        EncoderDecoderTest.testObjectSerialization(Boolean.FALSE);
        EncoderDecoderTest.testObjectSerialization((byte)0);
        EncoderDecoderTest.testObjectSerialization((byte)1);
        EncoderDecoderTest.testObjectSerialization((byte)-1);
        EncoderDecoderTest.testObjectSerialization((byte)-128);
        EncoderDecoderTest.testObjectSerialization((byte)127);
        EncoderDecoderTest.testObjectSerialization((short)0);
        EncoderDecoderTest.testObjectSerialization((short)1);
        EncoderDecoderTest.testObjectSerialization((short)-1);
        EncoderDecoderTest.testObjectSerialization((short)Short.MIN_VALUE);
        EncoderDecoderTest.testObjectSerialization((short)Short.MAX_VALUE);
        EncoderDecoderTest.testObjectSerialization(0);
        EncoderDecoderTest.testObjectSerialization(1);
        EncoderDecoderTest.testObjectSerialization(-1);
        EncoderDecoderTest.testObjectSerialization(Integer.MIN_VALUE);
        EncoderDecoderTest.testObjectSerialization(Integer.MAX_VALUE);
        EncoderDecoderTest.testObjectSerialization(0L);
        EncoderDecoderTest.testObjectSerialization(1L);
        EncoderDecoderTest.testObjectSerialization(-1L);
        EncoderDecoderTest.testObjectSerialization(Long.MIN_VALUE);
        EncoderDecoderTest.testObjectSerialization(Long.MAX_VALUE);
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(0.0f));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(1.0f));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(-1.0f));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf((float)Math.E));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf((float)Math.PI));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(Float.MIN_VALUE));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(Float.MAX_VALUE));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(Float.MIN_NORMAL));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(Float.NaN));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(Float.NEGATIVE_INFINITY));
        EncoderDecoderTest.testObjectSerialization(Float.valueOf(Float.POSITIVE_INFINITY));
        EncoderDecoderTest.testObjectSerialization(0.0);
        EncoderDecoderTest.testObjectSerialization(1.0);
        EncoderDecoderTest.testObjectSerialization(-1.0);
        EncoderDecoderTest.testObjectSerialization(Math.E);
        EncoderDecoderTest.testObjectSerialization(Math.PI);
        EncoderDecoderTest.testObjectSerialization(Double.MIN_VALUE);
        EncoderDecoderTest.testObjectSerialization(Double.MAX_VALUE);
        EncoderDecoderTest.testObjectSerialization(Double.MIN_NORMAL);
        EncoderDecoderTest.testObjectSerialization(Double.NaN);
        EncoderDecoderTest.testObjectSerialization(Double.NEGATIVE_INFINITY);
        EncoderDecoderTest.testObjectSerialization(Double.POSITIVE_INFINITY);
        EncoderDecoderTest.testObjectSerialization("");
        EncoderDecoderTest.testObjectSerialization("abcdefg");
        EncoderDecoderTest.testObjectSerialization("ab\u1535\u0155xyz\u706f");
        EncoderDecoderTest.testObjectSerialization(new SimpleTypes(3637, 54876486548L, 65, "We're out looking for astronauts", 9095, 2.65767523));
        EncoderDecoderTest.testObjectSerialization(new SimpleTypes(705608724, -1L, -65, "Serve me the sky with a big slice of lemon", -128, 1.0E-7));
    }

    @Test
    void testArrayTypes() {
        Object[] array = new int[]{1, 2, 3, 4, 5};
        EncoderDecoderTest.testObjectSerialization(array);
        array = new long[]{1L, 2L, 3L, 4L, 5L};
        EncoderDecoderTest.testObjectSerialization(array);
        array = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        EncoderDecoderTest.testObjectSerialization(array);
        array = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        EncoderDecoderTest.testObjectSerialization(array);
        array = new String[]{"Oh", "my", "what", "do", "we", "have", "here", "?"};
        EncoderDecoderTest.testObjectSerialization(array);
    }

    @Test
    void testEmptyArray() {
        Object[] array = new int[]{};
        EncoderDecoderTest.testObjectSerialization(array);
        array = new long[0];
        EncoderDecoderTest.testObjectSerialization(array);
        array = new float[0];
        EncoderDecoderTest.testObjectSerialization(array);
        array = new double[0];
        EncoderDecoderTest.testObjectSerialization(array);
        array = new String[0];
        EncoderDecoderTest.testObjectSerialization(array);
    }

    @Test
    void testObjects() {
        EncoderDecoderTest.testObjectSerialization(new Book(976243875L, "The Serialization Odysse", 42L));
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        EncoderDecoderTest.testObjectSerialization(new BookAuthor(976243875L, list, "Arno Nym"));
        list = new ArrayList();
        EncoderDecoderTest.testObjectSerialization(new BookAuthor(987654321L, list, "The Saurus"));
    }

    @Test
    void testNestedObjectsWithCollections() {
        EncoderDecoderTest.testObjectSerialization(new ComplexNestedObject2(true));
    }

    @Test
    void testGeneratedObjectWithNullableFields() {
        List<CharSequence> strings = Arrays.asList("These", "strings", "should", "be", "recognizable", "as", "a", "meaningful", "sequence");
        List<Boolean> bools = Arrays.asList(true, true, false, false, true, false, true, true);
        HashMap<CharSequence, Long> map = new HashMap<CharSequence, Long>();
        map.put("1", 1L);
        map.put("2", 2L);
        map.put("3", 3L);
        byte[] b = new byte[16];
        new Random().nextBytes(b);
        Fixed16 f = new Fixed16(b);
        Address addr = new Address(239, "6th Main", "Bangalore", "Karnataka", "560075");
        User user = new User("Freudenreich", 1337, "macintosh gray", 1234567890L, 3.1415926, null, true, strings, bools, null, Colors.GREEN, map, f, Boolean.TRUE, addr, ByteBuffer.wrap(b), LocalDate.parse("2014-03-01"), LocalTime.parse("12:12:12"), LocalTime.ofSecondOfDay(0L).plus(123456L, ChronoUnit.MICROS), Instant.parse("2014-03-01T12:12:12.321Z"), Instant.ofEpochSecond(0L).plus(123456L, ChronoUnit.MICROS), ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()), new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        EncoderDecoderTest.testObjectSerialization(user);
    }

    @Test
    void testVarLenCountEncoding() {
        try {
            long[] values = new long[]{0L, 1L, 2L, 3L, 4L, 0L, 574L, 45236L, 0L, 234623462L, 23462462346L, 0L, 9734028767869761L, Long.MAX_VALUE};
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            DataOutputStream dataOut = new DataOutputStream(baos);
            for (long val : values) {
                DataOutputEncoder.writeVarLongCount((DataOutput)dataOut, (long)val);
            }
            dataOut.flush();
            dataOut.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DataInputStream dataIn = new DataInputStream(bais);
            for (long val : values) {
                long read = DataInputDecoder.readVarLongCount((DataInput)dataIn);
                ((AbstractLongAssert)Assertions.assertThat((long)read).withFailMessage("Wrong var-len encoded value read.", new Object[0])).isEqualTo(val);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test failed due to an exception: " + e.getMessage()));
        }
    }

    private static <X> void testObjectSerialization(X obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            DataOutputStream dataOut = new DataOutputStream(baos);
            DataOutputEncoder encoder = new DataOutputEncoder();
            encoder.setOut((DataOutput)dataOut);
            Class<?> clazz = obj.getClass();
            ReflectDatumWriter writer = new ReflectDatumWriter(clazz);
            writer.write(obj, (Encoder)encoder);
            dataOut.flush();
            dataOut.close();
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dataIn = new DataInputStream(bais);
            DataInputDecoder decoder = new DataInputDecoder();
            decoder.setIn((DataInput)dataIn);
            Class<?> clazz2 = obj.getClass();
            ReflectDatumReader reader = new ReflectDatumReader(clazz2);
            Object reuse = null;
            try {
                Object test = obj.getClass().newInstance();
                reuse = test;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object result = reader.read(reuse, (Decoder)decoder);
            String message = "Deserialized object is not the same as the original";
            if (obj.getClass().isArray()) {
                Class<?> clazz3 = obj.getClass();
                if (clazz3 == byte[].class) {
                    Assertions.assertThat((byte[])((byte[])result)).containsExactly((byte[])obj);
                } else if (clazz3 == short[].class) {
                    Assertions.assertThat((short[])((short[])result)).containsExactly((short[])obj);
                } else if (clazz3 == int[].class) {
                    Assertions.assertThat((int[])((int[])result)).containsExactly((int[])obj);
                } else if (clazz3 == long[].class) {
                    Assertions.assertThat((long[])((long[])result)).containsExactly((long[])obj);
                } else if (clazz3 == char[].class) {
                    Assertions.assertThat((char[])((char[])result)).containsExactly((char[])obj);
                } else if (clazz3 == float[].class) {
                    Assertions.assertThat((float[])((float[])result)).containsExactly((float[])obj);
                } else if (clazz3 == double[].class) {
                    Assertions.assertThat((double[])((double[])result)).containsExactly((double[])obj);
                } else {
                    Assertions.assertThat((Object[])((Object[])result)).containsExactly((Object[])obj);
                }
            } else {
                ((ObjectAssert)Assertions.assertThat((Object)result).withFailMessage("Deserialized object is not the same as the original", new Object[0])).isEqualTo(obj);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test failed due to an exception: " + e.getMessage()));
        }
    }

    private static class BookAuthor {
        private long authorId;
        private List<String> bookTitles;
        private String authorName;

        public BookAuthor() {
        }

        public BookAuthor(long authorId, List<String> bookTitles, String authorName) {
            this.authorId = authorId;
            this.bookTitles = bookTitles;
            this.authorName = authorName;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == BookAuthor.class) {
                BookAuthor other = (BookAuthor)obj;
                return other.authorName.equals(this.authorName) && other.authorId == this.authorId && other.bookTitles.equals(this.bookTitles);
            }
            return false;
        }
    }

    private static class Book {
        private long bookId;
        private String title;
        private long authorId;

        public Book() {
        }

        public Book(long bookId, String title, long authorId) {
            this.bookId = bookId;
            this.title = title;
            this.authorId = authorId;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == Book.class) {
                Book other = (Book)obj;
                return other.bookId == this.bookId && other.authorId == this.authorId && this.title.equals(other.title);
            }
            return false;
        }
    }

    private static class ComplexNestedObject2 {
        private long longValue;
        private Map<String, ComplexNestedObject1> theMap;

        public ComplexNestedObject2() {
        }

        public ComplexNestedObject2(boolean init) {
            this.longValue = 46547L;
            this.theMap = new HashMap<String, ComplexNestedObject1>();
            this.theMap.put("36354L", new ComplexNestedObject1(43546543));
            this.theMap.put("785611L", new ComplexNestedObject1(45784568));
            this.theMap.put("43L", new ComplexNestedObject1(9876543));
            this.theMap.put("-45687L", new ComplexNestedObject1(7897615));
            this.theMap.put("1919876876896L", new ComplexNestedObject1(27154));
            this.theMap.put("-868468468L", new ComplexNestedObject1(546435));
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == ComplexNestedObject2.class) {
                ComplexNestedObject2 other = (ComplexNestedObject2)obj;
                return other.longValue == this.longValue && this.theMap.equals(other.theMap);
            }
            return false;
        }
    }

    private static class ComplexNestedObject1 {
        private double doubleValue;
        private List<String> stringList;

        public ComplexNestedObject1() {
        }

        public ComplexNestedObject1(int offInit) {
            this.doubleValue = 6293485.6723 + (double)offInit;
            this.stringList = new ArrayList<String>();
            this.stringList.add("A" + offInit);
            this.stringList.add("somewhat" + offInit);
            this.stringList.add("random" + offInit);
            this.stringList.add("collection" + offInit);
            this.stringList.add("of" + offInit);
            this.stringList.add("strings" + offInit);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == ComplexNestedObject1.class) {
                ComplexNestedObject1 other = (ComplexNestedObject1)obj;
                return other.doubleValue == this.doubleValue && this.stringList.equals(other.stringList);
            }
            return false;
        }
    }

    private static final class SimpleTypes {
        private final int iVal;
        private final long lVal;
        private final byte bVal;
        private final String sVal;
        private final short rVal;
        private final double dVal;

        public SimpleTypes() {
            this(0, 0L, 0, "", 0, 0.0);
        }

        public SimpleTypes(int iVal, long lVal, byte bVal, String sVal, short rVal, double dVal) {
            this.iVal = iVal;
            this.lVal = lVal;
            this.bVal = bVal;
            this.sVal = sVal;
            this.rVal = rVal;
            this.dVal = dVal;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == SimpleTypes.class) {
                SimpleTypes other = (SimpleTypes)obj;
                return other.iVal == this.iVal && other.lVal == this.lVal && other.bVal == this.bVal && other.sVal.equals(this.sVal) && other.rVal == this.rVal && other.dVal == this.dVal;
            }
            return false;
        }
    }
}

