/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AvroKryoSerializerTests {
    public static <T> T flinkToBytesAndBack(TypeSerializer<T> serializer, T originalObject) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper((OutputStream)out);){
            serializer.serialize(originalObject, (DataOutputView)outView);
        }
        try (DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(out.toByteArray()));){
            Object object = serializer.deserialize((DataInputView)inView);
            return (T)object;
        }
    }

    public static Object kryoToBytesAndBack(Kryo kryo, Object originalObject) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Output output = new Output((OutputStream)byteArrayOutputStream);){
            kryo.writeClassAndObject(output, originalObject);
            output.flush();
        }
        try (Input input = new Input((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
            Object object = kryo.readClassAndObject(input);
            return object;
        }
    }

    public <T> void testTypeSerialization(Class<T> javaClass, T originalObject) throws IOException {
        ExecutionConfig ec = new ExecutionConfig();
        SerializerConfig serializerConfig = ec.getSerializerConfig();
        TypeInformation typeInformation = TypeExtractor.createTypeInfo(javaClass);
        Serializers.recursivelyRegisterType((Class)typeInformation.getTypeClass(), (SerializerConfig)serializerConfig, new HashSet());
        TypeSerializer serializer = typeInformation.createSerializer(serializerConfig);
        T deserializedObject = AvroKryoSerializerTests.flinkToBytesAndBack(serializer, originalObject);
        Assertions.assertEquals(originalObject, deserializedObject);
        Object copiedObject = serializer.copy(originalObject);
        Assertions.assertEquals(originalObject, (Object)copiedObject);
        if (serializer instanceof KryoSerializer) {
            KryoSerializer kryoSerializer = (KryoSerializer)serializer;
            T kryoDeserializedObject = javaClass.cast(AvroKryoSerializerTests.kryoToBytesAndBack(kryoSerializer.getKryo(), originalObject));
            Assertions.assertEquals(originalObject, kryoDeserializedObject);
        }
    }

    @Test
    public void testGenericRecord() throws IOException {
        Schema timestampMilliType = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema recordSchema = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"demoRecord").namespace("demo")).fields().name("timestamp").type(timestampMilliType).noDefault().name("arrayOfStrings").type().array().items().stringType()).noDefault().endRecord();
        GenericData.Record testRecordA = new GenericRecordBuilder(recordSchema).set("timestamp", (Object)LocalDateTime.of(2025, 2, 20, 16, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli()).set("arrayOfStrings", Arrays.asList("aaa", "bbb", "ccc")).build();
        this.testTypeSerialization(GenericRecord.class, testRecordA);
    }

    @Test
    public void testHomogeneousRecordArray() throws IOException {
        Schema timestampMilliType = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema recordSchema = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"demoRecord").namespace("demo")).fields().name("timestamp").type(timestampMilliType).noDefault().name("arrayOfStrings").type().array().items().stringType()).noDefault().endRecord();
        GenericData.Record testRecordA = new GenericRecordBuilder(recordSchema).set("timestamp", (Object)LocalDateTime.of(2025, 2, 20, 16, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli()).set("arrayOfStrings", Arrays.asList("aaa", "bbb", "ccc")).build();
        GenericData.Record testRecordB = new GenericRecordBuilder(recordSchema).set("timestamp", (Object)LocalDateTime.of(2025, 1, 20, 14, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli()).set("arrayOfStrings", Arrays.asList("zzz", "yyy", "xxx")).build();
        Schema arraySchema = Schema.createArray((Schema)recordSchema);
        GenericData.Array genericRecordArray = new GenericData.Array(arraySchema, List.of(testRecordA, testRecordB));
        this.testTypeSerialization(GenericData.Array.class, genericRecordArray);
    }

    @Test
    public void testHeterogeneousArray() throws IOException {
        Schema unionSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().intType()).and().stringType()).endUnion();
        Schema arraySchema = Schema.createArray((Schema)unionSchema);
        GenericData.Array heterogeneousArray = new GenericData.Array(arraySchema, List.of(new Utf8("aaa"), Integer.valueOf(123), new Utf8("zzz"), Integer.valueOf(456)));
        this.testTypeSerialization(GenericData.Array.class, heterogeneousArray);
    }

    @Test
    public void testNullValues() throws IOException {
        this.testTypeSerialization(Schema.class, null);
        this.testTypeSerialization(GenericRecord.class, null);
        this.testTypeSerialization(GenericData.Array.class, null);
    }
}

