/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.RegistryAvroDeserializationSchema;
import org.apache.flink.formats.avro.SchemaCoder;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.SimpleRecord;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class RegistryAvroDeserializationSchemaTest {
    private static final Address address = TestDataGenerator.generateRandomAddress(new Random());

    RegistryAvroDeserializationSchemaTest() {
    }

    @Test
    void testGenericRecordReadWithCompatibleSchema() throws IOException {
        RegistryAvroDeserializationSchema deserializer = new RegistryAvroDeserializationSchema(GenericRecord.class, (Schema)SchemaBuilder.record((String)"Address").fields().requiredString("street").requiredInt("num").optionalString("country").endRecord(), (SchemaCoder.SchemaCoderProvider & Serializable)() -> new SchemaCoder(){

            public Schema readSchema(InputStream in) {
                return Address.getClassSchema();
            }

            public void writeSchema(Schema schema, OutputStream out) throws IOException {
            }
        });
        GenericRecord genericRecord = (GenericRecord)deserializer.deserialize(AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema()));
        Assertions.assertThat((Object)genericRecord.get("num")).isEqualTo((Object)address.getNum());
        Assertions.assertThat((String)genericRecord.get("street").toString()).isEqualTo((Object)address.getStreet());
        Assertions.assertThat((Object)genericRecord.get("country")).isNull();
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSpecificRecordReadMoreFieldsThanWereWritten(AvroFormatOptions.AvroEncoding encoding) throws IOException {
        final Schema smallerUserSchema = new Schema.Parser().parse("{\"namespace\": \"org.apache.flink.formats.avro.generated\",\n \"type\": \"record\",\n \"name\": \"SimpleRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"} ]\n}");
        RegistryAvroDeserializationSchema deserializer = new RegistryAvroDeserializationSchema(SimpleRecord.class, null, (SchemaCoder.SchemaCoderProvider & Serializable)() -> new SchemaCoder(){

            public Schema readSchema(InputStream in) {
                return smallerUserSchema;
            }

            public void writeSchema(Schema schema, OutputStream out) throws IOException {
            }
        }, encoding);
        GenericData.Record smallUser = new GenericRecordBuilder(smallerUserSchema).set("name", (Object)"someName").build();
        SimpleRecord simpleRecord = (SimpleRecord)((Object)deserializer.deserialize(AvroTestUtils.writeRecord((GenericRecord)smallUser, smallerUserSchema, encoding)));
        Assertions.assertThat((String)simpleRecord.getName().toString()).isEqualTo("someName");
        Assertions.assertThat((Integer)simpleRecord.getOptionalField()).isNull();
    }
}

