/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.common;

import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.Location;
import java.util.regex.Pattern;

public class ImportOptions {

    public static final class ExcludeShadedImportOption
    implements ImportOption {
        private static final Pattern SHADED = Pattern.compile(".*/shaded/.*");

        public boolean includes(Location location) {
            return !location.matches(SHADED);
        }
    }

    public static final class ExcludeScalaImportOption
    implements ImportOption {
        private static final Pattern SCALA = Pattern.compile(".*/scala/.*");

        public boolean includes(Location location) {
            return !location.matches(SCALA);
        }
    }

    public static final class MavenMainClassesOnly
    implements ImportOption {
        private static final Pattern MAVEN = Pattern.compile(".*/target/classes/.*");

        public boolean includes(Location location) {
            return location.matches(MAVEN);
        }
    }
}

