/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public abstract class AbstractAnonymizer<K>
implements Anonymizer<K> {
    protected SchemaManager schemaManager;
    protected Map<String, Anonymizer<K>> attributeAnonymizers = new HashMap<String, Anonymizer<K>>();
    protected boolean caseSensitive = false;
    private static final char[] NOT_SENSITIVE_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'()-./".toCharArray();
    private static final char[] SENSITIVE_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'()-./abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int[] CHAR_MAP = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 37, 38, 0, 0, 0, 39, 40, 41, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 0, 0, 0, 0, 26, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 0, 0, 0, 0, 0};

    protected AbstractAnonymizer() {
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public void setAnonymizers(Map<String, Anonymizer<K>> attributeAnonymizers) {
        this.attributeAnonymizers = attributeAnonymizers;
    }

    @Override
    public Map<Integer, String> getLatestStringMap() {
        return null;
    }

    @Override
    public void setLatestStringMap(Map<Integer, String> latestStringMap) {
    }

    @Override
    public Map<Integer, byte[]> getLatestBytesMap() {
        return null;
    }

    @Override
    public void setLatestBytesMap(Map<Integer, byte[]> latestBytesMap) {
    }

    protected String computeNewValue(String valStr) {
        int length = valStr.length();
        String latestString = this.getLatestStringMap().get(length);
        char[] charMap = this.caseSensitive ? SENSITIVE_MAP : NOT_SENSITIVE_MAP;
        int lastMapChar = charMap.length - 1;
        if (latestString == null) {
            char[] newValue = new char[length];
            Arrays.fill(newValue, charMap[0]);
            String anonymizedValue = new String(newValue);
            this.getLatestStringMap().put(length, anonymizedValue);
            return anonymizedValue;
        }
        char[] latest = latestString.toCharArray();
        boolean overflow = true;
        for (int i = length - 1; i >= 0; --i) {
            if (latest[i] != charMap[lastMapChar]) {
                latest[i] = charMap[CHAR_MAP[latest[i]] + 1];
                overflow = false;
                break;
            }
            latest[i] = charMap[0];
        }
        String anonymizedValue = new String(latest);
        if (overflow) {
            String msg = I18n.err((I18n)I18n.ERR_13435_CANNOT_COMPUTE_NEW_VALUE, (Object[])new Object[]{anonymizedValue});
            throw new RuntimeException(msg);
        }
        this.getLatestStringMap().put(length, anonymizedValue);
        return anonymizedValue;
    }

    protected byte[] computeNewValue(byte[] valBytes) {
        int length = valBytes.length;
        byte[] latestBytes = this.getLatestBytesMap().get(length);
        if (latestBytes == null) {
            byte[] newValue = new byte[length];
            Arrays.fill(newValue, (byte)65);
            this.getLatestBytesMap().put(length, newValue);
            return newValue;
        }
        boolean overflow = true;
        for (int i = length - 1; i >= 0; --i) {
            if (latestBytes[i] != 90) {
                int n = i;
                latestBytes[n] = (byte)(latestBytes[n] + 1);
                overflow = false;
                break;
            }
            latestBytes[i] = 65;
        }
        if (overflow) {
            String msg = I18n.err((I18n)I18n.ERR_13435_CANNOT_COMPUTE_NEW_VALUE, (Object[])new Object[]{latestBytes});
            throw new RuntimeException(msg);
        }
        return latestBytes;
    }
}

