/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.i18n.I18n;

public final class Oid {
    private byte[] oidBytes;
    private String oidString;
    private static final BigInteger JOINT_ISO_ITU_T = BigInteger.valueOf(80L);

    private Oid(String oidString, byte[] oidBytes) {
        this.oidString = oidString;
        this.oidBytes = new byte[oidBytes.length];
        System.arraycopy(oidBytes, 0, this.oidBytes, 0, oidBytes.length);
    }

    public boolean equals(Object other) {
        return other instanceof Oid && this.oidString.equals(((Oid)other).oidString);
    }

    public static Oid fromBytes(byte[] oidBytes) throws DecoderException {
        if (oidBytes == null || oidBytes.length < 1) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{Arrays.toString(oidBytes)}));
        }
        StringBuilder builder = new StringBuilder();
        long value = 0L;
        int valStart = 0;
        int valLength = 0;
        boolean firstArc = true;
        for (int i = 0; i < oidBytes.length; ++i) {
            value |= (long)(oidBytes[i] & 0x7F);
            if (oidBytes[i] < 0) {
                value <<= 7;
                ++valLength;
                continue;
            }
            if (++valLength > 8) {
                int j;
                int nbBytes = valLength * 7 / 8;
                if (valLength % 7 != 0) {
                    ++nbBytes;
                }
                byte[] result = new byte[nbBytes];
                int pos = nbBytes - 1;
                int valEnd = valStart + valLength - 1;
                for (j = 0; j < valLength - 8; j += 8) {
                    result[pos--] = (byte)(oidBytes[valEnd - j - 1] << 7 | oidBytes[valEnd - j] & 0x7F);
                    result[pos--] = (byte)(oidBytes[valEnd - j - 2] << 6 | (oidBytes[valEnd - j - 1] & 0x7E) >> 1);
                    result[pos--] = (byte)(oidBytes[valEnd - j - 3] << 5 | (oidBytes[valEnd - j - 2] & 0x7C) >> 2);
                    result[pos--] = (byte)(oidBytes[valEnd - j - 4] << 4 | (oidBytes[valEnd - j - 3] & 0x78) >> 3);
                    result[pos--] = (byte)(oidBytes[valEnd - j - 5] << 3 | (oidBytes[valEnd - j - 4] & 0x70) >> 4);
                    result[pos--] = (byte)(oidBytes[valEnd - j - 6] << 2 | (oidBytes[valEnd - j - 5] & 0x60) >> 5);
                    result[pos--] = (byte)(oidBytes[valEnd - j - 7] << 1 | (oidBytes[valEnd - j - 6] & 0x40) >> 6);
                }
                switch (valLength - j) {
                    case 7: {
                        result[pos--] = (byte)(oidBytes[5] << 7 | oidBytes[6] & 0x7F);
                        result[pos--] = (byte)(oidBytes[4] << 6 | (oidBytes[5] & 0x7E) >> 1);
                        result[pos--] = (byte)(oidBytes[3] << 5 | (oidBytes[4] & 0x7C) >> 2);
                        result[pos--] = (byte)(oidBytes[2] << 4 | (oidBytes[3] & 0x78) >> 3);
                        result[pos--] = (byte)(oidBytes[1] << 3 | (oidBytes[2] & 0x70) >> 4);
                        result[pos--] = (byte)(oidBytes[0] << 2 | (oidBytes[1] & 0x60) >> 5);
                        result[pos] = (byte)((oidBytes[0] & 0x40) >> 6);
                        break;
                    }
                    case 6: {
                        result[pos--] = (byte)(oidBytes[4] << 7 | oidBytes[5] & 0x7F);
                        result[pos--] = (byte)(oidBytes[3] << 6 | (oidBytes[4] & 0x7E) >> 1);
                        result[pos--] = (byte)(oidBytes[2] << 5 | (oidBytes[3] & 0x7C) >> 2);
                        result[pos--] = (byte)(oidBytes[1] << 4 | (oidBytes[2] & 0x78) >> 3);
                        result[pos--] = (byte)(oidBytes[0] << 3 | (oidBytes[1] & 0x70) >> 4);
                        result[pos] = (byte)((oidBytes[0] & 0x60) >> 5);
                        break;
                    }
                    case 5: {
                        result[pos--] = (byte)(oidBytes[3] << 7 | oidBytes[4] & 0x7F);
                        result[pos--] = (byte)(oidBytes[2] << 6 | (oidBytes[3] & 0x7E) >> 1);
                        result[pos--] = (byte)(oidBytes[1] << 5 | (oidBytes[2] & 0x7C) >> 2);
                        result[pos--] = (byte)(oidBytes[0] << 4 | (oidBytes[1] & 0x78) >> 3);
                        result[pos] = (byte)((oidBytes[0] & 0x70) >> 4);
                        break;
                    }
                    case 4: {
                        result[pos--] = (byte)(oidBytes[2] << 7 | oidBytes[3] & 0x7F);
                        result[pos--] = (byte)(oidBytes[1] << 6 | (oidBytes[2] & 0x7E) >> 1);
                        result[pos--] = (byte)(oidBytes[0] << 5 | (oidBytes[1] & 0x7C) >> 2);
                        result[pos] = (byte)((oidBytes[0] & 0x78) >> 3);
                        break;
                    }
                    case 3: {
                        result[pos--] = (byte)(oidBytes[1] << 7 | oidBytes[2] & 0x7F);
                        result[pos--] = (byte)(oidBytes[0] << 6 | (oidBytes[1] & 0x7E) >> 1);
                        result[pos] = (byte)((oidBytes[0] & 0x7C) >> 2);
                        break;
                    }
                    case 2: {
                        result[pos--] = (byte)(oidBytes[0] << 7 | oidBytes[1] & 0x7F);
                        result[pos] = (byte)((oidBytes[0] & 0x7E) >> 1);
                        break;
                    }
                    case 1: {
                        result[pos] = (byte)(oidBytes[0] & 0x7F);
                        break;
                    }
                }
                if ((result[0] & 0x80) == 128) {
                    byte[] newResult = new byte[result.length + 1];
                    System.arraycopy(result, 0, newResult, 1, result.length);
                    result = newResult;
                }
                BigInteger bigInteger = new BigInteger(result);
                if (firstArc) {
                    bigInteger = bigInteger.subtract(JOINT_ISO_ITU_T);
                    builder.append('2');
                }
                builder.append('.').append(bigInteger.toString());
            } else {
                if (firstArc) {
                    if (value >= 80L) {
                        builder.append('2');
                        value -= 80L;
                    } else {
                        long one = value / 40L;
                        long two = value % 40L;
                        if (one < 0L || one > 2L || two < 0L || one < 2L && two > 39L) {
                            throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{Arrays.toString(oidBytes)}));
                        }
                        if (one < 2L) {
                            builder.append(one);
                            value = two;
                        }
                    }
                    firstArc = false;
                }
                builder.append('.').append(value);
            }
            valStart = i;
            valLength = 0;
            value = 0L;
        }
        return new Oid(builder.toString(), oidBytes);
    }

    private static OidFSAState processStateStart(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '0': 
            case '1': {
                buffer[0] = (byte)((c - 48) * 40);
                return OidFSAState.STATE_A;
            }
            case '2': {
                return OidFSAState.STATE_F;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"Should start with 0, 1 or 2"}));
    }

    private static OidFSAState processStateA(String oid, int pos) throws DecoderException {
        if (oid.charAt(pos) != '.') {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a '.' is expected"}));
        }
        return OidFSAState.STATE_B;
    }

    private static OidFSAState processStateB(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '0': {
                return OidFSAState.STATE_D;
            }
            case '1': 
            case '2': 
            case '3': {
                buffer[1] = (byte)(c - 48);
                return OidFSAState.STATE_C;
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                buffer[0] = (byte)(buffer[0] + (byte)(c - 48));
                return OidFSAState.STATE_E;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateC(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                buffer[0] = (byte)(buffer[0] + (byte)(buffer[1] * 10 + (c - 48)));
                buffer[1] = 0;
                return OidFSAState.STATE_E;
            }
            case '.': {
                buffer[0] = (byte)(buffer[0] + buffer[1]);
                buffer[1] = 0;
                return OidFSAState.STATE_K;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateDE(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        if (c != '.') {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a dot is expected"}));
        }
        buffer[0] = (byte)(buffer[0] | buffer[1]);
        buffer[1] = 0;
        return OidFSAState.STATE_K;
    }

    private static OidFSAState processStateF(String oid, int pos) throws DecoderException {
        if (oid.charAt(pos) != '.') {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a '.' is expected"}));
        }
        return OidFSAState.STATE_G;
    }

    private static OidFSAState processStateG(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '0': {
                buffer[0] = 80;
                return OidFSAState.STATE_I;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                buffer[0] = (byte)(c - 48);
                return OidFSAState.STATE_H;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateH(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                buffer[1] = (byte)(c - 48);
                return OidFSAState.STATE_J;
            }
            case '.': {
                buffer[0] = (byte)(80 + buffer[0]);
                return OidFSAState.STATE_K;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateI(String oid, byte[] buffer, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        if (c == '.') {
            buffer[0] = (byte)(80 + buffer[1]);
            return OidFSAState.STATE_K;
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateJ(String oid, byte[] buffer, int bufferPos, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '.': {
                return OidFSAState.STATE_K;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                buffer[bufferPos] = (byte)(c - 48);
                return OidFSAState.STATE_J;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateK(String oid, byte[] buffer, int bufferPos, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '0': {
                buffer[bufferPos] = 0;
                return OidFSAState.STATE_M;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return OidFSAState.STATE_L;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit is expected"}));
    }

    private static OidFSAState processStateL(String oid, byte[] buffer, int bufferPos, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        switch (c) {
            case '.': {
                return OidFSAState.STATE_K;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                buffer[bufferPos] = (byte)(c - 48);
                return OidFSAState.STATE_L;
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a digit or a dot is expected"}));
    }

    private static OidFSAState processStateM(String oid, int pos) throws DecoderException {
        char c = oid.charAt(pos);
        if (c == '.') {
            return OidFSAState.STATE_K;
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"a '.' is expected"}));
    }

    private static int convert(String oid, byte[] buffer, int start, int nbDigits, int posBuffer, boolean isJointIsoItuT) {
        if (nbDigits < 3) {
            if (isJointIsoItuT) {
                buffer[0] = (byte)(80 + (oid.charAt(2) - 48) * 10 + (oid.charAt(3) - 48));
                if (buffer[0] < 0) {
                    buffer[1] = (byte)(buffer[0] & 0x7F);
                    buffer[0] = -127;
                    return 2;
                }
                return 1;
            }
            buffer[posBuffer] = nbDigits == 1 ? (byte)(oid.charAt(start) - 48) : (byte)((oid.charAt(start) - 48) * 10 + (oid.charAt(start + 1) - 48));
            return 1;
        }
        if (nbDigits < 19) {
            String number = oid.substring(start, start + nbDigits);
            long value = Long.parseLong(number);
            if (isJointIsoItuT) {
                value += 80L;
            }
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer[posBuffer] = (byte)value;
                return 1;
            }
            if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 1] = (byte)(value & 0x7FL);
                return 2;
            }
            if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
                buffer[posBuffer + 1] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 2] = (byte)(value & 0x7FL);
                return 3;
            }
            if ((value & 0xFFFFFFFFF0000000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0xFE00000L) >> 21) | 0x80);
                buffer[posBuffer + 1] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
                buffer[posBuffer + 2] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 3] = (byte)(value & 0x7FL);
                return 4;
            }
            if ((value & 0xFFFFFFF800000000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0x7F0000000L) >> 28) | 0x80);
                buffer[posBuffer + 1] = (byte)((byte)((value & 0xFE00000L) >> 21) | 0x80);
                buffer[posBuffer + 2] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
                buffer[posBuffer + 3] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 4] = (byte)(value & 0x7FL);
                return 5;
            }
            if ((value & 0xFFFFFC0000000000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0x3F800000000L) >> 35) | 0x80);
                buffer[posBuffer + 1] = (byte)((byte)((value & 0x7F0000000L) >> 28) | 0x80);
                buffer[posBuffer + 2] = (byte)((byte)((value & 0xFE00000L) >> 21) | 0x80);
                buffer[posBuffer + 3] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
                buffer[posBuffer + 4] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 5] = (byte)(value & 0x7FL);
                return 6;
            }
            if ((value & 0xFFFE000000000000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0x1FC0000000000L) >> 42) | 0x80);
                buffer[posBuffer + 1] = (byte)((byte)((value & 0x3F800000000L) >> 35) | 0x80);
                buffer[posBuffer + 2] = (byte)((byte)((value & 0x7F0000000L) >> 28) | 0x80);
                buffer[posBuffer + 3] = (byte)((byte)((value & 0xFE00000L) >> 21) | 0x80);
                buffer[posBuffer + 4] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
                buffer[posBuffer + 5] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 6] = (byte)(value & 0x7FL);
                return 7;
            }
            if ((value & 0xFF00000000000000L) == 0L) {
                buffer[posBuffer] = (byte)((byte)((value & 0xFE000000000000L) >> 49) | 0x80);
                buffer[posBuffer + 1] = (byte)((byte)((value & 0x1FC0000000000L) >> 42) | 0x80);
                buffer[posBuffer + 2] = (byte)((byte)((value & 0x3F800000000L) >> 35) | 0x80);
                buffer[posBuffer + 3] = (byte)((byte)((value & 0x7F0000000L) >> 28) | 0x80);
                buffer[posBuffer + 4] = (byte)((byte)((value & 0xFE00000L) >> 21) | 0x80);
                buffer[posBuffer + 5] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
                buffer[posBuffer + 6] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
                buffer[posBuffer + 7] = (byte)(value & 0x7FL);
                return 8;
            }
            buffer[posBuffer] = (byte)((byte)((value & 0x7F00000000000000L) >> 56) | 0x80);
            buffer[posBuffer + 1] = (byte)((byte)((value & 0xFE000000000000L) >> 49) | 0x80);
            buffer[posBuffer + 2] = (byte)((byte)((value & 0x1FC0000000000L) >> 42) | 0x80);
            buffer[posBuffer + 3] = (byte)((byte)((value & 0x3F800000000L) >> 35) | 0x80);
            buffer[posBuffer + 4] = (byte)((byte)((value & 0x7F0000000L) >> 28) | 0x80);
            buffer[posBuffer + 5] = (byte)((byte)((value & 0xFE00000L) >> 21) | 0x80);
            buffer[posBuffer + 6] = (byte)((byte)((value & 0x1FC000L) >> 14) | 0x80);
            buffer[posBuffer + 7] = (byte)((byte)((value & 0x3F80L) >> 7) | 0x80);
            buffer[posBuffer + 8] = (byte)(value & 0x7FL);
            return 9;
        }
        String number = oid.substring(start, start + nbDigits);
        BigInteger bigInteger = new BigInteger(number);
        if (isJointIsoItuT) {
            bigInteger = bigInteger.add(JOINT_ISO_ITU_T);
            posBuffer = 0;
        }
        byte[] bytes = bigInteger.toByteArray();
        int nbNeededBytes = bytes.length * 8 / 7;
        switch ((bytes.length - 1) % 7) {
            case 0: {
                if ((bytes[0] & 0x80) == 0) break;
                ++nbNeededBytes;
                break;
            }
            case 1: {
                if ((bytes[0] & 0xC0) == 0) break;
                ++nbNeededBytes;
                break;
            }
            case 2: {
                if ((bytes[0] & 0xE0) == 0) break;
                ++nbNeededBytes;
                break;
            }
            case 3: {
                if ((bytes[0] & 0xF0) == 0) break;
                ++nbNeededBytes;
                break;
            }
            case 4: {
                if ((bytes[0] & 0xF8) == 0) break;
                ++nbNeededBytes;
                break;
            }
            case 5: {
                if ((bytes[0] & 0xFC) == 0) break;
                ++nbNeededBytes;
                break;
            }
            case 6: {
                if ((bytes[0] & 0xFE) == 0) break;
                ++nbNeededBytes;
                break;
            }
        }
        byte[] converted = new byte[nbNeededBytes];
        int posConverted = nbNeededBytes - 1;
        int posBytes = bytes.length - 1;
        int counter = 0;
        byte reminder = 0;
        while (posBytes >= 0) {
            byte newByte = (byte)((bytes[posBytes] & 0xFF) << counter);
            converted[posConverted] = (byte)(reminder | newByte | 0x80);
            reminder = (byte)((bytes[posBytes] & 0xFF) >> 7 - counter);
            counter = (counter + 1) % 8;
            --posConverted;
            if (counter != 0) {
                --posBytes;
                continue;
            }
            reminder = 0;
        }
        int n = nbNeededBytes - 1;
        converted[n] = (byte)(converted[n] & 0x7F);
        System.arraycopy(converted, 0, buffer, posBuffer, nbNeededBytes);
        return nbNeededBytes;
    }

    public static Oid fromString(String oidString) throws DecoderException {
        if (oidString == null || oidString.isEmpty()) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"empty"}));
        }
        byte[] buffer = new byte[oidString.length()];
        OidFSAState state = OidFSAState.START;
        int arcNbChars = 0;
        int bufPos = 0;
        int startArc = 0;
        block21: for (int i = 0; i < oidString.length(); ++i) {
            switch (state) {
                case START: {
                    state = Oid.processStateStart(oidString, buffer, i);
                    continue block21;
                }
                case STATE_A: {
                    state = Oid.processStateA(oidString, i);
                    continue block21;
                }
                case STATE_B: {
                    state = Oid.processStateB(oidString, buffer, i);
                    continue block21;
                }
                case STATE_C: {
                    state = Oid.processStateC(oidString, buffer, i);
                    bufPos = 1;
                    continue block21;
                }
                case STATE_D: 
                case STATE_E: {
                    state = Oid.processStateDE(oidString, buffer, i);
                    bufPos = 1;
                    continue block21;
                }
                case STATE_F: {
                    state = Oid.processStateF(oidString, i);
                    continue block21;
                }
                case STATE_G: {
                    state = Oid.processStateG(oidString, buffer, i);
                    arcNbChars = 1;
                    startArc = i;
                    continue block21;
                }
                case STATE_H: {
                    state = Oid.processStateH(oidString, buffer, i);
                    if (state != OidFSAState.STATE_J) continue block21;
                    arcNbChars = 2;
                    bufPos = 0;
                    continue block21;
                }
                case STATE_I: {
                    state = Oid.processStateI(oidString, buffer, i);
                    bufPos = 1;
                    continue block21;
                }
                case STATE_J: {
                    state = Oid.processStateJ(oidString, buffer, arcNbChars + bufPos, i);
                    if (state == OidFSAState.STATE_J) {
                        ++arcNbChars;
                        continue block21;
                    }
                    bufPos += Oid.convert(oidString, buffer, startArc, arcNbChars, bufPos, true);
                    continue block21;
                }
                case STATE_K: {
                    startArc = i;
                    state = Oid.processStateK(oidString, buffer, bufPos, i);
                    if (state == OidFSAState.STATE_M) {
                        ++bufPos;
                        continue block21;
                    }
                    arcNbChars = 1;
                    continue block21;
                }
                case STATE_L: {
                    state = Oid.processStateL(oidString, buffer, arcNbChars + bufPos, i);
                    if (state == OidFSAState.STATE_L) {
                        ++arcNbChars;
                        continue block21;
                    }
                    bufPos += Oid.convert(oidString, buffer, startArc, arcNbChars, bufPos, false);
                    continue block21;
                }
                case STATE_M: {
                    state = Oid.processStateM(oidString, i);
                    continue block21;
                }
            }
        }
        switch (state) {
            case STATE_C: 
            case STATE_D: 
            case STATE_E: 
            case STATE_H: 
            case STATE_I: {
                byte[] bytes = new byte[]{(byte)(buffer[0] | buffer[1])};
                return new Oid(oidString, bytes);
            }
            case STATE_J: {
                int nbBytes = Oid.convert(oidString, buffer, 2, arcNbChars, 0, true);
                byte[] bytes = new byte[nbBytes];
                System.arraycopy(buffer, 0, bytes, 0, nbBytes);
                return new Oid(oidString, bytes);
            }
            case STATE_L: {
                bufPos += Oid.convert(oidString, buffer, startArc, arcNbChars, bufPos, false);
                byte[] bytes = new byte[bufPos];
                System.arraycopy(buffer, 0, bytes, 0, bufPos);
                return new Oid(oidString, bytes);
            }
            case STATE_M: {
                byte[] bytes = new byte[bufPos];
                System.arraycopy(buffer, 0, bytes, 0, bufPos);
                return new Oid(oidString, bytes);
            }
        }
        throw new DecoderException(I18n.err((I18n)I18n.ERR_00003_INVALID_OID, (Object[])new Object[]{"Wrong OID"}));
    }

    public int getEncodedLength() {
        return this.oidBytes.length;
    }

    public int hashCode() {
        return this.oidString.hashCode();
    }

    public static boolean isOid(String oidString) {
        try {
            Oid.fromString(oidString);
            return true;
        }
        catch (DecoderException e) {
            return false;
        }
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.oidBytes, this.oidBytes.length);
    }

    public String toString() {
        return this.oidString;
    }

    public void writeBytesTo(ByteBuffer buffer) {
        buffer.put(this.oidBytes);
    }

    public void writeBytesTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.oidBytes);
    }

    private static enum OidFSAState {
        START,
        STATE_A,
        STATE_B,
        STATE_C,
        STATE_D,
        STATE_E,
        STATE_F,
        STATE_G,
        STATE_H,
        STATE_I,
        STATE_J,
        STATE_K,
        STATE_L,
        STATE_M;

    }
}

