/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.apache.camel.test.infra.aws2.common.SystemPropertiesAWSCredentialsProvider;
import org.apache.camel.test.infra.aws2.common.TestAWSCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.transcribe.TranscribeClient;

public final class AWSSDKClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AWSSDKClientUtils.class);

    private AWSSDKClientUtils() {
    }

    private static URI getEndpoint() {
        String amazonHost = System.getProperty("aws.host");
        if (amazonHost == null || amazonHost.isEmpty()) {
            return null;
        }
        try {
            return new URI(String.format("http://%s", amazonHost));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid endpoint");
        }
    }

    private static boolean isLocalContainer(String awsInstanceType) {
        return awsInstanceType == null || awsInstanceType.equals("local-aws-container");
    }

    private static <T extends AwsClientBuilder<T, Y>, Y extends SdkClient> Y newClient(String property, String name, Supplier<T> clientBuilderSupplier) {
        AwsClientBuilder clientBuilder = (AwsClientBuilder)clientBuilderSupplier.get();
        LOG.debug("Creating a new AWS v2 {} client", (Object)name);
        String awsInstanceType = System.getProperty(property);
        clientBuilder.region(Region.US_EAST_1);
        URI endpoint = AWSSDKClientUtils.getEndpoint();
        if (AWSSDKClientUtils.isLocalContainer(awsInstanceType) || endpoint != null) {
            clientBuilder.endpointOverride(endpoint);
        }
        if (AWSSDKClientUtils.isLocalContainer(awsInstanceType)) {
            clientBuilder.credentialsProvider((AwsCredentialsProvider)TestAWSCredentialsProvider.CONTAINER_LOCAL_DEFAULT_PROVIDER);
        } else {
            clientBuilder.credentialsProvider((AwsCredentialsProvider)new SystemPropertiesAWSCredentialsProvider());
        }
        if (clientBuilder instanceof S3ClientBuilder) {
            ((S3ClientBuilder)clientBuilder).forcePathStyle(Boolean.valueOf(true));
        }
        return (Y)((SdkClient)clientBuilder.build());
    }

    private static <T extends AwsClientBuilder<T, Y>, Y extends SdkClient> Y newClient(String name, Supplier<T> clientBuilderSupplier) {
        return AWSSDKClientUtils.newClient("aws-service.instance.type", name, clientBuilderSupplier);
    }

    public static KinesisClient newKinesisClient() {
        return (KinesisClient)AWSSDKClientUtils.newClient("aws-service.kinesis.instance.type", "Kinesis", KinesisClient::builder);
    }

    public static SqsClient newSQSClient() {
        return (SqsClient)AWSSDKClientUtils.newClient("SQS", SqsClient::builder);
    }

    public static S3Client newS3Client() {
        return (S3Client)AWSSDKClientUtils.newClient("S3", S3Client::builder);
    }

    public static SnsClient newSNSClient() {
        return (SnsClient)AWSSDKClientUtils.newClient("SNS", SnsClient::builder);
    }

    public static ConfigClient newConfigClient() {
        return (ConfigClient)AWSSDKClientUtils.newClient("Config", ConfigClient::builder);
    }

    public static CloudWatchClient newCloudWatchClient() {
        return (CloudWatchClient)AWSSDKClientUtils.newClient("Cloud Watch", CloudWatchClient::builder);
    }

    public static Ec2Client newEC2Client() {
        return (Ec2Client)AWSSDKClientUtils.newClient("EC2", Ec2Client::builder);
    }

    public static EventBridgeClient newEventBridgeClient() {
        return (EventBridgeClient)AWSSDKClientUtils.newClient("EventBridge", EventBridgeClient::builder);
    }

    public static IamClient newIAMClient() {
        return (IamClient)AWSSDKClientUtils.newClient("EventBridge", IamClient::builder);
    }

    public static KmsClient newKMSClient() {
        return (KmsClient)AWSSDKClientUtils.newClient("KMS", KmsClient::builder);
    }

    public static LambdaClient newLambdaClient() {
        return (LambdaClient)AWSSDKClientUtils.newClient("Lambda", LambdaClient::builder);
    }

    public static SecretsManagerClient newSecretsManagerClient() {
        return (SecretsManagerClient)AWSSDKClientUtils.newClient("SecretsManager", SecretsManagerClient::builder);
    }

    public static StsClient newSTSClient() {
        return (StsClient)AWSSDKClientUtils.newClient("STS", StsClient::builder);
    }

    public static DynamoDbClient newDynamoDBClient() {
        return (DynamoDbClient)AWSSDKClientUtils.newClient("DynamoDB", DynamoDbClient::builder);
    }

    public static TranscribeClient newTranscribeClient() {
        return (TranscribeClient)AWSSDKClientUtils.newClient("Transcribe", TranscribeClient::builder);
    }
}

