/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramEndpoint;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.model.Update;
import org.apache.camel.component.telegram.model.UpdateResult;
import org.apache.camel.component.telegram.util.TelegramMessageHelper;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramConsumer.class);
    private TelegramEndpoint endpoint;
    private volatile Long offset;

    public TelegramConsumer(TelegramEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected int poll() throws Exception {
        TelegramConfiguration config = this.endpoint.getConfiguration();
        TelegramService service = this.endpoint.getTelegramService();
        LOG.debug("Polling Telegram service to get updates");
        UpdateResult updateResult = service.getUpdates(this.offset, config.getLimit(), config.getTimeout());
        if (updateResult.getUpdates() == null) {
            updateResult.setUpdates(Collections.emptyList());
        }
        if (!updateResult.isOk()) {
            throw new IllegalStateException("The server was unable to process the request. Response was " + updateResult);
        }
        List<Update> updates = updateResult.getUpdates();
        if (!updates.isEmpty()) {
            LOG.debug("Received {} updates from Telegram service", (Object)updates.size());
        } else {
            LOG.debug("No updates received from Telegram service");
        }
        this.processUpdates(updates);
        this.updateOffset(updates);
        return updates.size();
    }

    private void processUpdates(List<Update> updates) throws Exception {
        for (Update update : updates) {
            LOG.debug("Received update from Telegram service: {}", (Object)update);
            Exchange exchange = this.createExchange(update);
            this.getProcessor().process(exchange);
        }
    }

    private void updateOffset(List<Update> updates) {
        OptionalLong ol = updates.stream().mapToLong(Update::getUpdateId).max();
        if (ol.isPresent()) {
            this.offset = ol.getAsLong() + 1L;
            LOG.debug("Next Telegram offset will be {}", (Object)this.offset);
        }
    }

    private Exchange createExchange(Update update) {
        Exchange exchange = this.createExchange(true);
        TelegramMessageHelper.populateExchange(exchange, update);
        return exchange;
    }
}

