/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.util;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.TelegramMediaType;
import org.apache.camel.component.telegram.TelegramParseMode;
import org.apache.camel.component.telegram.model.IncomingMessage;
import org.apache.camel.component.telegram.model.OutgoingAudioMessage;
import org.apache.camel.component.telegram.model.OutgoingDocumentMessage;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.OutgoingPhotoMessage;
import org.apache.camel.component.telegram.model.OutgoingTextMessage;
import org.apache.camel.component.telegram.model.OutgoingVideoMessage;
import org.apache.camel.component.telegram.model.ReplyMarkup;
import org.apache.camel.component.telegram.model.Update;

@Converter(generateLoader=true)
public final class TelegramConverter {
    private TelegramConverter() {
    }

    @Converter
    public static String toString(Update update, Exchange exchange) {
        return TelegramConverter.toString(update.getMessage(), exchange);
    }

    @Converter
    public static String toString(IncomingMessage message, Exchange exchange) {
        return message.getText();
    }

    @Converter
    public static OutgoingMessage toOutgoingMessage(Object message, Exchange exchange) {
        String content = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, message);
        return TelegramConverter.toOutgoingMessage(content, exchange);
    }

    @Converter
    public static OutgoingMessage toOutgoingMessage(String message, Exchange exchange) {
        Object typeObj = exchange.getIn().getHeader("CamelTelegramMediaType");
        TelegramMediaType type = typeObj instanceof String ? TelegramMediaType.valueOf((String)typeObj) : (TelegramMediaType)((Object)typeObj);
        if (type == null) {
            type = TelegramMediaType.TEXT;
        }
        return switch (type) {
            case TelegramMediaType.TEXT -> {
                OutgoingTextMessage txt = new OutgoingTextMessage();
                txt.setText(message);
                TelegramParseMode parseMode = TelegramConverter.getParseMode(exchange);
                if (parseMode != null) {
                    txt.setParseMode(parseMode.getCode());
                }
                yield txt;
            }
            default -> throw new IllegalArgumentException("Unsupported conversion from String to media type " + type);
        };
    }

    @Converter
    public static OutgoingMessage toOutgoingMessage(byte[] message, Exchange exchange) {
        Object typeObj = exchange.getIn().getHeader("CamelTelegramMediaType");
        TelegramMediaType type = typeObj instanceof String ? TelegramMediaType.valueOf((String)typeObj) : (TelegramMediaType)((Object)typeObj);
        if (type == null) {
            throw new IllegalStateException("Binary message require the header CamelTelegramMediaType to be set with an appropriate org.apache.camel.component.telegram.TelegramMediaType object");
        }
        return switch (type) {
            case TelegramMediaType.PHOTO_JPG, TelegramMediaType.PHOTO_PNG -> {
                OutgoingPhotoMessage img = new OutgoingPhotoMessage();
                String caption = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                ReplyMarkup replyMarkup = (ReplyMarkup)exchange.getIn().getHeader("CamelTelegramMediaMarkup");
                String fileName = "photo." + type.getFileExtension();
                img.setCaption(caption);
                img.setFilenameWithExtension(fileName);
                img.setPhoto(message);
                img.setReplyMarkup(replyMarkup);
                yield img;
            }
            case TelegramMediaType.AUDIO -> {
                OutgoingAudioMessage audio = new OutgoingAudioMessage();
                String title = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                ReplyMarkup replyMarkup = (ReplyMarkup)exchange.getIn().getHeader("CamelTelegramMediaMarkup");
                String fileName = "audio." + type.getFileExtension();
                audio.setTitle(title);
                audio.setFilenameWithExtension(fileName);
                audio.setAudio(message);
                audio.setReplyMarkup(replyMarkup);
                yield audio;
            }
            case TelegramMediaType.VIDEO -> {
                OutgoingVideoMessage video = new OutgoingVideoMessage();
                String title = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                ReplyMarkup replyMarkup = (ReplyMarkup)exchange.getIn().getHeader("CamelTelegramMediaMarkup");
                String fileName = "video." + type.getFileExtension();
                video.setCaption(title);
                video.setFilenameWithExtension(fileName);
                video.setVideo(message);
                video.setReplyMarkup(replyMarkup);
                yield video;
            }
            default -> {
                OutgoingDocumentMessage document = new OutgoingDocumentMessage();
                String title = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                ReplyMarkup replyMarkup = (ReplyMarkup)exchange.getIn().getHeader("CamelTelegramMediaMarkup");
                document.setCaption(title);
                document.setFilenameWithExtension("file");
                document.setDocument(message);
                document.setReplyMarkup(replyMarkup);
                yield document;
            }
        };
    }

    private static TelegramParseMode getParseMode(Exchange exchange) {
        Object parseMode = exchange.getIn().getHeader("CamelTelegramParseMode");
        TelegramParseMode mode = parseMode instanceof String ? TelegramParseMode.valueOf((String)parseMode) : (TelegramParseMode)((Object)parseMode);
        return mode;
    }
}

