/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(StreamProducer.class);
    private static final String TYPES = "out,err,file,header";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{out,err,file,header}'";
    private static final List<String> TYPES_LIST = Arrays.asList("out,err,file,header".split(","));
    private StreamEndpoint endpoint;
    private String uri;
    private OutputStream outputStream;
    private final AtomicInteger count = new AtomicInteger();

    public StreamProducer(StreamEndpoint endpoint, String uri) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.validateUri(uri);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.closeStream(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.delay(this.endpoint.getDelay());
            this.lock.lock();
            try {
                try {
                    this.openStream(exchange);
                    this.writeToStream(this.outputStream, exchange);
                }
                finally {
                    this.closeStream(exchange, false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            exchange.setException((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private OutputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFileName();
        StringHelper.notEmpty((String)fileName, (String)"fileName");
        LOG.debug("About to write to file: {}", (Object)fileName);
        File f = new File(fileName);
        f.getParentFile().mkdirs();
        f.createNewFile();
        return new FileOutputStream(f, true);
    }

    private OutputStream resolveStreamFromHeader(Object o, Exchange exchange) {
        return (OutputStream)exchange.getContext().getTypeConverter().convertTo(OutputStream.class, o);
    }

    private void delay(long ms) throws InterruptedException {
        if (ms == 0L) {
            return;
        }
        LOG.trace("Delaying {} millis", (Object)ms);
        Thread.sleep(ms);
    }

    private void writeToStream(OutputStream outputStream, Exchange exchange) throws IOException, CamelExchangeException {
        byte[] bytes;
        Object body = exchange.getIn().getBody();
        if (body == null) {
            LOG.debug("Body is null, cannot write it to the stream.");
            return;
        }
        if (!(body instanceof String) && (bytes = (byte[])exchange.getIn().getBody(byte[].class)) != null) {
            LOG.debug("Writing as byte[]: {} to {}", (Object)bytes, (Object)outputStream);
            outputStream.write(bytes);
            if (this.endpoint.isAppendNewLine()) {
                outputStream.write(System.lineSeparator().getBytes());
            }
            return;
        }
        String s = (String)exchange.getIn().getMandatoryBody(String.class);
        Charset charset = this.endpoint.getCharset();
        OutputStreamWriter writer = charset != null ? new OutputStreamWriter(outputStream, charset) : new OutputStreamWriter(outputStream);
        BufferedWriter bw = IOHelper.buffered((Writer)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing as text: {} to {} using encoding: {}", new Object[]{body, outputStream, charset});
        }
        bw.write(s);
        if (this.endpoint.isAppendNewLine()) {
            bw.write(System.lineSeparator());
        }
        bw.flush();
    }

    private void openStream() throws Exception {
        if (this.outputStream != null) {
            return;
        }
        if ("out".equals(this.uri)) {
            this.outputStream = System.out;
        } else if ("err".equals(this.uri)) {
            this.outputStream = System.err;
        } else if ("file".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromFile();
        }
        this.count.set(this.outputStream == null ? 0 : this.endpoint.getAutoCloseCount());
        LOG.debug("Opened stream '{}'", (Object)this.endpoint.getEndpointKey());
    }

    private void openStream(Exchange exchange) throws Exception {
        if (this.outputStream != null) {
            return;
        }
        if ("header".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromHeader(exchange.getIn().getHeader("stream"), exchange);
            LOG.debug("Opened stream '{}'", (Object)this.endpoint.getEndpointKey());
        } else {
            this.openStream();
        }
    }

    private Boolean isDone(Exchange exchange) {
        return exchange != null && (Boolean)exchange.getProperty(ExchangePropertyKey.SPLIT_COMPLETE, (Object)Boolean.FALSE, Boolean.class) != false;
    }

    private void closeStream(Exchange exchange, boolean force) throws Exception {
        boolean expiredStream;
        if (this.outputStream == null) {
            return;
        }
        boolean systemStream = this.outputStream == System.out || this.outputStream == System.err;
        boolean headerStream = "header".equals(this.uri);
        boolean reachedLimit = this.endpoint.getAutoCloseCount() > 0 && this.count.decrementAndGet() <= 0;
        boolean isDone = this.endpoint.isCloseOnDone() && this.isDone(exchange) != false;
        boolean bl = expiredStream = force || headerStream || isDone || reachedLimit;
        if (!systemStream && expiredStream) {
            this.outputStream.close();
            this.outputStream = null;
            LOG.debug("Closed stream '{}'", (Object)this.endpoint.getEndpointKey());
        }
    }

    private void validateUri(String uri) throws Exception {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (this.uri.startsWith("//")) {
            this.uri = this.uri.substring(2);
        }
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

