/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.process;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.htmlxlsx.model.CamelContextRouteCoverage;
import org.apache.camel.maven.htmlxlsx.model.Components;
import org.apache.camel.maven.htmlxlsx.model.Route;
import org.apache.camel.maven.htmlxlsx.model.Routes;
import org.apache.camel.maven.htmlxlsx.model.TestResult;

public class TestResultParser {
    private final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    public TestResult parse(TestResult testResult) {
        CamelContextRouteCoverage camelContextRouteCoverage = testResult.getCamelContextRouteCoverage();
        Routes routes = camelContextRouteCoverage.getRoutes();
        List<Route> routeList = routes.getRouteList();
        routeList.forEach(route -> route.setComponents(this.components((Route)route)));
        return testResult;
    }

    protected Components components(Route route) {
        Components components;
        try {
            Map<String, Object> componentsMap = route.getComponentsMap();
            String asString = this.objectMapper().writeValueAsString(componentsMap);
            components = (Components)this.objectMapper().readValue(asString, Components.class);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return components;
    }

    protected ObjectMapper objectMapper() {
        return this.objectMapper;
    }
}

