/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.routepolicy.quartz.ScheduledJob;
import org.apache.camel.routepolicy.quartz.ScheduledJobState;
import org.apache.camel.routepolicy.quartz.ScheduledRouteDetails;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledRoutePolicy
extends RoutePolicySupport
implements ScheduledRoutePolicyConstants,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledRoutePolicy.class);
    protected Map<String, ScheduledRouteDetails> scheduledRouteDetailsMap = new LinkedHashMap<String, ScheduledRouteDetails>();
    private Scheduler scheduler;
    @Metadata(description="Timeout (in millis) when stopping routes.", defaultValue="10000")
    private int routeStopGracePeriod;
    private TimeUnit timeUnit;

    protected abstract Trigger createTrigger(ScheduledRoutePolicyConstants.Action var1, Route var2) throws Exception;

    public void onJobExecute(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        LOG.debug("Scheduled Event notification received. Performing action: {} on route: {}", (Object)action, (Object)route.getId());
        ServiceStatus routeStatus = route.getCamelContext().getRouteController().getRouteStatus(route.getId());
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            if (routeStatus == ServiceStatus.Stopped) {
                this.startRoute(route);
            } else if (ServiceHelper.isSuspended((Object)route.getConsumer())) {
                this.resumeOrStartConsumer(route.getConsumer());
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            if (routeStatus == ServiceStatus.Started || routeStatus == ServiceStatus.Suspended) {
                this.stopRoute(route, this.getRouteStopGracePeriod(), this.getTimeUnit());
            } else {
                LOG.warn("Route is not in a started/suspended state and cannot be stopped. The current route state is {}", (Object)routeStatus);
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            if (routeStatus == ServiceStatus.Started) {
                this.suspendOrStopConsumer(route.getConsumer());
            } else {
                LOG.warn("Route is not in a started state and cannot be suspended. The current route state is {}", (Object)routeStatus);
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            if (routeStatus == ServiceStatus.Started) {
                if (ServiceHelper.isSuspended((Object)route.getConsumer())) {
                    this.resumeOrStartConsumer(route.getConsumer());
                } else {
                    LOG.warn("The Consumer {} is not suspended and cannot be resumed.", (Object)route.getConsumer());
                }
            } else {
                LOG.warn("Route is not in a started state and cannot be resumed. The current route state is {}", (Object)routeStatus);
            }
        }
    }

    public void onRemove(Route route) {
        try {
            this.doStop();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void scheduleRoute(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        JobDetail existingJobDetail;
        JobDetail jobDetail = this.createJobDetail(action, route);
        Trigger trigger = this.createTrigger(action, route);
        this.updateScheduledRouteDetails(action, jobDetail, trigger, route);
        this.loadCallbackDataIntoSchedulerContext(jobDetail, action, route);
        boolean isClustered = ((QuartzComponent)route.getCamelContext().getComponent("quartz", QuartzComponent.class)).isClustered();
        if (isClustered && jobDetail.equals(existingJobDetail = this.getScheduler().getJobDetail(jobDetail.getKey()))) {
            LOG.info("Skipping to schedule the job: {} for action: {} on route {} as the job: {} already existing inside the cluster", new Object[]{jobDetail.getKey(), action, route.getId(), existingJobDetail.getKey()});
            return;
        }
        this.getScheduler().scheduleJob(jobDetail, trigger);
        if (LOG.isInfoEnabled()) {
            LOG.info("Scheduled trigger: {} for action: {} on route {}", new Object[]{trigger.getKey(), action, route.getId()});
        }
    }

    public void pauseRouteTrigger(ScheduledRoutePolicyConstants.Action action, String routeId) throws SchedulerException {
        TriggerKey triggerKey = this.retrieveTriggerKey(action, routeId);
        this.getScheduler().pauseTrigger(triggerKey);
        LOG.debug("Scheduled trigger: {} is paused", (Object)triggerKey);
    }

    public void resumeRouteTrigger(ScheduledRoutePolicyConstants.Action action, String routeId) throws SchedulerException {
        TriggerKey triggerKey = this.retrieveTriggerKey(action, routeId);
        this.getScheduler().resumeTrigger(triggerKey);
        LOG.debug("Scheduled trigger: {} is resumed", (Object)triggerKey);
    }

    protected void doStop() throws Exception {
        for (ScheduledRouteDetails scheduledRouteDetails : this.scheduledRouteDetailsMap.values()) {
            if (scheduledRouteDetails.getStartJobKey() != null) {
                this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.START, scheduledRouteDetails);
            }
            if (scheduledRouteDetails.getStopJobKey() != null) {
                this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.STOP, scheduledRouteDetails);
            }
            if (scheduledRouteDetails.getSuspendJobKey() != null) {
                this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.SUSPEND, scheduledRouteDetails);
            }
            if (scheduledRouteDetails.getResumeJobKey() == null) continue;
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.RESUME, scheduledRouteDetails);
        }
    }

    public void deleteRouteJob(ScheduledRoutePolicyConstants.Action action, ScheduledRouteDetails scheduledRouteDetails) throws SchedulerException {
        JobKey jobKey = this.retrieveJobKey(action, scheduledRouteDetails);
        if (!this.getScheduler().isShutdown()) {
            this.getScheduler().deleteJob(jobKey);
        }
        LOG.debug("Scheduled job: {} is deleted", (Object)jobKey);
    }

    protected JobDetail createJobDetail(ScheduledRoutePolicyConstants.Action action, Route route) {
        JobDetail jobDetail = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetail = JobBuilder.newJob(ScheduledJob.class).withIdentity(JOB_START + route.getId(), "jobGroup-" + route.getId()).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetail = JobBuilder.newJob(ScheduledJob.class).withIdentity(JOB_STOP + route.getId(), "jobGroup-" + route.getId()).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetail = JobBuilder.newJob(ScheduledJob.class).withIdentity(JOB_SUSPEND + route.getId(), "jobGroup-" + route.getId()).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetail = JobBuilder.newJob(ScheduledJob.class).withIdentity(JOB_RESUME + route.getId(), "jobGroup-" + route.getId()).build();
        }
        return jobDetail;
    }

    protected void updateScheduledRouteDetails(ScheduledRoutePolicyConstants.Action action, JobDetail jobDetail, Trigger trigger, Route route) {
        ScheduledRouteDetails scheduledRouteDetails = this.getScheduledRouteDetails(route.getId());
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            scheduledRouteDetails.setStartJobKey(jobDetail.getKey());
            scheduledRouteDetails.setStartTriggerKey(trigger.getKey());
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            scheduledRouteDetails.setStopJobKey(jobDetail.getKey());
            scheduledRouteDetails.setStopTriggerKey(trigger.getKey());
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            scheduledRouteDetails.setSuspendJobKey(jobDetail.getKey());
            scheduledRouteDetails.setSuspendTriggerKey(trigger.getKey());
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            scheduledRouteDetails.setResumeJobKey(jobDetail.getKey());
            scheduledRouteDetails.setResumeTriggerKey(trigger.getKey());
        }
    }

    protected void loadCallbackDataIntoSchedulerContext(JobDetail jobDetail, ScheduledRoutePolicyConstants.Action action, Route route) throws SchedulerException {
        this.getScheduler().getContext().put(jobDetail.getKey().toString(), (Object)new ScheduledJobState(action, route));
    }

    public TriggerKey retrieveTriggerKey(ScheduledRoutePolicyConstants.Action action, String routeId) {
        ScheduledRouteDetails scheduledRouteDetails = this.getScheduledRouteDetails(routeId);
        TriggerKey result = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            result = scheduledRouteDetails.getStartTriggerKey();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            result = scheduledRouteDetails.getStopTriggerKey();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            result = scheduledRouteDetails.getSuspendTriggerKey();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            result = scheduledRouteDetails.getResumeTriggerKey();
        }
        return result;
    }

    public JobKey retrieveJobKey(ScheduledRoutePolicyConstants.Action action, ScheduledRouteDetails scheduledRouteDetails) {
        JobKey result = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            result = scheduledRouteDetails.getStartJobKey();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            result = scheduledRouteDetails.getStopJobKey();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            result = scheduledRouteDetails.getSuspendJobKey();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            result = scheduledRouteDetails.getResumeJobKey();
        }
        return result;
    }

    protected void registerRouteToScheduledRouteDetails(Route route) {
        ScheduledRouteDetails scheduledRouteDetails = new ScheduledRouteDetails();
        this.scheduledRouteDetailsMap.put(route.getId(), scheduledRouteDetails);
    }

    protected ScheduledRouteDetails getScheduledRouteDetails(String routeId) {
        return this.scheduledRouteDetailsMap.get(routeId);
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setRouteStopGracePeriod(int routeStopGracePeriod) {
        this.routeStopGracePeriod = routeStopGracePeriod;
    }

    public int getRouteStopGracePeriod() {
        return this.routeStopGracePeriod;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

