/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.netty.NettyConverter;
import org.apache.camel.component.netty.http.NettyChannelBufferStreamCache;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.http.HttpUtil;

@Converter(generateLoader=true)
public final class NettyHttpConverter {
    private NettyHttpConverter() {
    }

    @Converter(fallback=true)
    public static Object convertToHttpRequest(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        NettyHttpMessage msg;
        if (value != null && HttpRequest.class.isAssignableFrom(type) && (msg = (NettyHttpMessage)((Object)exchange.getMessage(NettyHttpMessage.class))) != null && msg.getBody() == value) {
            FullHttpRequest request = msg.getHttpRequest();
            request.content().resetReaderIndex();
            return request;
        }
        return null;
    }

    @Converter(fallback=true)
    public static Object convertToHttpResponse(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        NettyHttpMessage msg;
        if (value != null && HttpResponse.class.isAssignableFrom(type) && (msg = (NettyHttpMessage)((Object)exchange.getMessage(NettyHttpMessage.class))) != null && msg.getBody() == value) {
            return msg.getHttpResponse();
        }
        return null;
    }

    @Converter
    public static String toString(FullHttpResponse response, Exchange exchange) {
        String contentType = response.headers().get("Content-Type");
        String charset = HttpUtil.getCharsetFromContentType((String)contentType);
        if (charset == null && exchange != null) {
            charset = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
        }
        if (charset != null) {
            return response.content().toString(Charset.forName(charset));
        }
        return response.content().toString(Charset.defaultCharset());
    }

    @Converter
    public static byte[] toBytes(FullHttpResponse response, Exchange exchange) {
        return NettyConverter.toByteArray((ByteBuf)response.content(), (Exchange)exchange);
    }

    @Converter
    public static InputStream toInputStream(FullHttpResponse response, Exchange exchange) {
        return NettyConverter.toInputStream((ByteBuf)response.content(), (Exchange)exchange);
    }

    @Converter
    public static ByteBuf toByteBuf(NettyChannelBufferStreamCache cache, Exchange exchange) throws Exception {
        cache.reset();
        int len = (int)cache.length();
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(len);
        buf.writeBytes((InputStream)cache, len);
        return buf;
    }
}

