/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleSecretManagerConfiguration
implements Cloneable {
    @UriPath(label="common", description="The Google Cloud Project Id name related to the Secret Manager")
    @Metadata(required=true)
    private String project;
    @UriParam(label="common", description="Service account key to authenticate an application as a service account")
    private String serviceAccountKey;
    @UriParam(label="producer", enums="createSecret")
    private GoogleSecretManagerOperations operation;
    @UriParam(defaultValue="false", description="Specifies if the request is a pojo request")
    private boolean pojoRequest;
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private SecretManagerServiceClient client;

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public GoogleSecretManagerOperations getOperation() {
        return this.operation;
    }

    public void setOperation(GoogleSecretManagerOperations operation) {
        this.operation = operation;
    }

    public SecretManagerServiceClient getClient() {
        return this.client;
    }

    public void setClient(SecretManagerServiceClient client) {
        this.client = client;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public GoogleSecretManagerConfiguration copy() {
        try {
            return (GoogleSecretManagerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

