/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CouchbaseEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol://hostname:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "couchbase".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "hostname", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", 8091, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(49);
        props.add("additionalHosts");
        props.add("autoStartIdForInserts");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("bucket");
        props.add("collection");
        props.add("connectTimeout");
        props.add("consumerProcessedStrategy");
        props.add("consumerRetryPause");
        props.add("delay");
        props.add("descending");
        props.add("designDocumentName");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fullDocument");
        props.add("greedy");
        props.add("hostname");
        props.add("initialDelay");
        props.add("key");
        props.add("lazyStartProducer");
        props.add("limit");
        props.add("operation");
        props.add("password");
        props.add("persistTo");
        props.add("pollStrategy");
        props.add("port");
        props.add("producerRetryAttempts");
        props.add("producerRetryPause");
        props.add("protocol");
        props.add("queryTimeout");
        props.add("rangeEndKey");
        props.add("rangeStartKey");
        props.add("repeatCount");
        props.add("replicateTo");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("scope");
        props.add("sendEmptyMessageWhenIdle");
        props.add("skip");
        props.add("startScheduler");
        props.add("startingIdForInsertsFrom");
        props.add("timeUnit");
        props.add("useFixedDelay");
        props.add("username");
        props.add("viewName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

