/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.mbean.ManagedProducerMBean;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="producer", displayName="Producers", description="Display information about Camel producers")
public class ProducerDevConsole
extends AbstractDevConsole {
    public ProducerDevConsole() {
        super("camel", "producer", "Producers", "Display information about Camel producers");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        MBeanServer mbeanServer = this.getCamelContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (mbeanServer != null) {
            try {
                String jmxDomain = this.getCamelContext().getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
                String prefix = this.getCamelContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
                ObjectName query = ObjectName.getInstance(jmxDomain + ":context=" + prefix + this.getCamelContext().getManagementName() + ",type=producers,*");
                Set<ObjectName> set = mbeanServer.queryNames(query, null);
                if (set != null && !set.isEmpty()) {
                    for (ObjectName on : set) {
                        ManagedProducerMBean mp = ProducerDevConsole.getManagedProducer(this.getCamelContext(), on);
                        if (!sb.isEmpty()) {
                            sb.append("\n");
                        }
                        sb.append(String.format("\n    Uri: %s", mp.getEndpointUri()));
                        sb.append(String.format("\n    State: %s", mp.getState()));
                        sb.append(String.format("\n    Class: %s", mp.getServiceType()));
                        sb.append(String.format("\n    Remote: %b", mp.isRemoteEndpoint()));
                        sb.append(String.format("\n    Singleton: %b", mp.isSingleton()));
                        if (mp.getRouteId() == null) continue;
                        sb.append(String.format("\n    Route Id: %s", mp.getRouteId()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put((Object)"producers", list);
        MBeanServer mbeanServer = this.getCamelContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (mbeanServer != null) {
            try {
                String jmxDomain = this.getCamelContext().getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
                String prefix = this.getCamelContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
                ObjectName query = ObjectName.getInstance(jmxDomain + ":context=" + prefix + this.getCamelContext().getManagementName() + ",type=producers,*");
                Set<ObjectName> set = mbeanServer.queryNames(query, null);
                if (set != null && !set.isEmpty()) {
                    for (ObjectName on : set) {
                        ManagedProducerMBean mp = ProducerDevConsole.getManagedProducer(this.getCamelContext(), on);
                        JsonObject jo = new JsonObject();
                        jo.put((Object)"uri", (Object)mp.getEndpointUri());
                        jo.put((Object)"state", (Object)mp.getState());
                        jo.put((Object)"class", (Object)mp.getServiceType());
                        jo.put((Object)"remote", (Object)mp.isRemoteEndpoint());
                        jo.put((Object)"singleton", (Object)mp.isSingleton());
                        if (mp.getRouteId() != null) {
                            jo.put((Object)"routeId", (Object)mp.getRouteId());
                        }
                        list.add(jo);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return root;
    }

    private static ManagedProducerMBean getManagedProducer(CamelContext camelContext, ObjectName on) {
        return (ManagedProducerMBean)camelContext.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProducerMBean.class);
    }
}

