/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuHostComponent;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface TahuHostComponentBuilderFactory {
    public static TahuHostComponentBuilder tahuHost() {
        return new TahuHostComponentBuilderImpl();
    }

    public static class TahuHostComponentBuilderImpl
    extends AbstractComponentBuilder<TahuHostComponent>
    implements TahuHostComponentBuilder {
        @Override
        protected TahuHostComponent buildConcreteComponent() {
            return new TahuHostComponent();
        }

        private TahuConfiguration getOrCreateConfiguration(TahuHostComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new TahuConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "checkClientIdLength": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setCheckClientIdLength(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setClientId((String)value);
                    return true;
                }
                case "keepAliveTimeout": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setKeepAliveTimeout(((Integer)value).intValue());
                    return true;
                }
                case "rebirthDebounceDelay": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setRebirthDebounceDelay(((Long)value).longValue());
                    return true;
                }
                case "servers": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setServers((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((TahuHostComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((TahuHostComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((TahuHostComponent)component).setConfiguration((TahuConfiguration)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setPassword((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((TahuHostComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((TahuHostComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface TahuHostComponentBuilder
    extends ComponentBuilder<TahuHostComponent> {
        default public TahuHostComponentBuilder checkClientIdLength(boolean checkClientIdLength) {
            this.doSetProperty("checkClientIdLength", checkClientIdLength);
            return this;
        }

        default public TahuHostComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public TahuHostComponentBuilder keepAliveTimeout(int keepAliveTimeout) {
            this.doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }

        default public TahuHostComponentBuilder rebirthDebounceDelay(long rebirthDebounceDelay) {
            this.doSetProperty("rebirthDebounceDelay", rebirthDebounceDelay);
            return this;
        }

        default public TahuHostComponentBuilder servers(String servers) {
            this.doSetProperty("servers", servers);
            return this;
        }

        default public TahuHostComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public TahuHostComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public TahuHostComponentBuilder configuration(TahuConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public TahuHostComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public TahuHostComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public TahuHostComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public TahuHostComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

