/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.time.Instant;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.cw.Cw2Component;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

public interface Aws2CwComponentBuilderFactory {
    public static Aws2CwComponentBuilder aws2Cw() {
        return new Aws2CwComponentBuilderImpl();
    }

    public static class Aws2CwComponentBuilderImpl
    extends AbstractComponentBuilder<Cw2Component>
    implements Aws2CwComponentBuilder {
        @Override
        protected Cw2Component buildConcreteComponent() {
            return new Cw2Component();
        }

        private Cw2Configuration getOrCreateConfiguration(Cw2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Cw2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Cw2Component)component).setConfiguration((Cw2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Cw2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "name": {
                    this.getOrCreateConfiguration((Cw2Component)component).setName((String)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Cw2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Cw2Component)component).setRegion((String)value);
                    return true;
                }
                case "timestamp": {
                    this.getOrCreateConfiguration((Cw2Component)component).setTimestamp((Instant)value);
                    return true;
                }
                case "unit": {
                    this.getOrCreateConfiguration((Cw2Component)component).setUnit((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Cw2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "value": {
                    this.getOrCreateConfiguration((Cw2Component)component).setValue((Double)value);
                    return true;
                }
                case "amazonCwClient": {
                    this.getOrCreateConfiguration((Cw2Component)component).setAmazonCwClient((CloudWatchClient)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Cw2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((Cw2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((Cw2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Cw2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Cw2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Cw2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Cw2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Cw2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Cw2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((Cw2Component)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Cw2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Cw2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Cw2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((Cw2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2CwComponentBuilder
    extends ComponentBuilder<Cw2Component> {
        default public Aws2CwComponentBuilder configuration(Cw2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2CwComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2CwComponentBuilder name(String name) {
            this.doSetProperty("name", name);
            return this;
        }

        default public Aws2CwComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2CwComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2CwComponentBuilder timestamp(Instant timestamp) {
            this.doSetProperty("timestamp", timestamp);
            return this;
        }

        default public Aws2CwComponentBuilder unit(String unit) {
            this.doSetProperty("unit", unit);
            return this;
        }

        default public Aws2CwComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2CwComponentBuilder value(Double value) {
            this.doSetProperty("value", value);
            return this;
        }

        default public Aws2CwComponentBuilder amazonCwClient(CloudWatchClient amazonCwClient) {
            this.doSetProperty("amazonCwClient", amazonCwClient);
            return this;
        }

        default public Aws2CwComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2CwComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2CwComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2CwComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2CwComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2CwComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2CwComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2CwComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2CwComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2CwComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Aws2CwComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2CwComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2CwComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2CwComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

