/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.redis.RedisComponent;
import org.springframework.data.redis.core.RedisTemplate;

public interface SpringRedisComponentBuilderFactory {
    public static SpringRedisComponentBuilder springRedis() {
        return new SpringRedisComponentBuilderImpl();
    }

    public static class SpringRedisComponentBuilderImpl
    extends AbstractComponentBuilder<RedisComponent>
    implements SpringRedisComponentBuilder {
        @Override
        protected RedisComponent buildConcreteComponent() {
            return new RedisComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "redisTemplate": {
                    ((RedisComponent)component).setRedisTemplate((RedisTemplate)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((RedisComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((RedisComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((RedisComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SpringRedisComponentBuilder
    extends ComponentBuilder<RedisComponent> {
        default public SpringRedisComponentBuilder redisTemplate(RedisTemplate<Object, Object> redisTemplate) {
            this.doSetProperty("redisTemplate", redisTemplate);
            return this;
        }

        default public SpringRedisComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public SpringRedisComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SpringRedisComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

